-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `mobile` varchar(100)    COMMENT '手机号',  
    `mail` varchar(100)    COMMENT '邮箱',  
    `pwd` varchar(100) NOT NULL   COMMENT '密码',  
    `alias` varchar(100)    COMMENT '用户名',  
    `name` varchar(100)    COMMENT '姓名',  
    `img` varchar(500)    COMMENT '头像',  
    `pay_pwd` varchar(100)    COMMENT '支付密码',  
    `grade` int NOT NULL   COMMENT '年级',  
    `location` varchar(500)    COMMENT '地址',  
    `score` bigint NOT NULL   COMMENT '积分',  
    `register_at` bigint NOT NULL   COMMENT '注册时间',  
    `last_login_at` bigint NOT NULL   COMMENT '上次登陆时间',  
    `status` bigint NOT NULL   COMMENT '冻结状态(1正常、2冻结)',  
    `wrong_count` int NOT NULL   COMMENT '登陆错误次数',  
    `consecutive` int NOT NULL   COMMENT '连续签到次数',  
    `sign_highest` int NOT NULL   COMMENT '历史最高签到次数',
    `sign` int NOT NULL   COMMENT '签到状态',
    `sign_total` int NOT NULL   COMMENT '签到总数',
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_openid_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_openid_relation`;
CREATE TABLE `user_openid_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户ID',  
    `openid` varchar(50) NOT NULL   COMMENT 'openId',  
    `type` varchar(20) NOT NULL   COMMENT '类型',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `sign`
-- ----------------------------
-- DROP TABLE IF EXISTS `sign`;
CREATE TABLE `sign` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `sign_at` bigint NOT NULL   COMMENT '签到时间',  
    `sign_date` bigint NOT NULL   COMMENT '签到日零点时间戳',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `notice`
-- ----------------------------
-- DROP TABLE IF EXISTS `notice`;
CREATE TABLE `notice` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `title` varchar(30) NOT NULL   COMMENT '公告栏标题',
    `context` text NOT NULL   COMMENT '公告栏内容',
    `status` int(1) NOT NULL   COMMENT '上下架状态',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `member`
-- ----------------------------
-- DROP TABLE IF EXISTS `member`;
CREATE TABLE `member` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(30) NOT NULL   COMMENT '套餐名称',
    `period` varchar(30) NOT NULL   COMMENT '持续时长',
    `price` varchar(30) NOT NULL   COMMENT '价格',
    `status` int(1) NOT NULL   COMMENT '上下架状态',
    `recommend` int(1) NOT NULL   COMMENT '推荐排序',
    `logo` varchar(500)    COMMENT '会员logo',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_member_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_member_relation`;
CREATE TABLE `user_member_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint NOT NULL   COMMENT '用户id',
    `name` varchar(30) NOT NULL   COMMENT '套餐名称',
    `period` varchar(30) NOT NULL   COMMENT '剩余时间',
    `price` varchar(30) NOT NULL   COMMENT '套餐价格',
    `start_at` bigint NOT NULL   COMMENT '套餐开始时间',
    `end_at` bigint NoT NULL   COMMENT '套餐结束时间',
    `status` int NOT NULL   COMMENT '上下架状态',
    `coupon_id` bigint    COMMENT '卡券ID',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;








-- ----------------------------
-- Table structure for `coupon`
-- ----------------------------
-- DROP TABLE IF EXISTS `coupon`;
CREATE TABLE `coupon` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `number` varchar(30) NOT NULL   COMMENT '卡号',
    `md5_pwd` varchar(500)    COMMENT '卡密md5加密',
    `pwd` varchar(8) NOT NULL   COMMENT '卡密',
    `period` varchar(30) NOT NULL   COMMENT '有效期',
    `deadline` bigint NOT NULL   COMMENT '失效日期',
    `name` varchar(30) NOT NULL   COMMENT '套餐名称',
    `price` varchar(30) NOT NULL   COMMENT '价格',
    `status` int(1) NOT NULL   COMMENT '已使用/过期/未使用',
    `member_id` bigint    COMMENT '会员ID',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;








