package com.ptteng.academy.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.academy.user.model.UesrCourseRelation;
import com.ptteng.academy.user.service.UesrCourseRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UesrCourseRelationServiceImpl extends BaseDaoServiceImpl implements UesrCourseRelationService {

 

	private static final Log log = LogFactory.getLog(UesrCourseRelationServiceImpl.class);



		   
		@Override
		public Long insert(UesrCourseRelation uesrCourseRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + uesrCourseRelation);

		if (uesrCourseRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		uesrCourseRelation.setCreateAt(currentTimeMillis);
		uesrCourseRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(uesrCourseRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + uesrCourseRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UesrCourseRelation> insertList(List<UesrCourseRelation> uesrCourseRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (uesrCourseRelationList == null ? "null" : uesrCourseRelationList.size()));
      
		List<UesrCourseRelation> resultList = null;

		if (CollectionUtils.isEmpty(uesrCourseRelationList)) {
			return new ArrayList<UesrCourseRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UesrCourseRelation uesrCourseRelation : uesrCourseRelationList) {
			uesrCourseRelation.setCreateAt(currentTimeMillis);
			uesrCourseRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UesrCourseRelation>) dao.batchSave(uesrCourseRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + uesrCourseRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UesrCourseRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UesrCourseRelation uesrCourseRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (uesrCourseRelation == null ? "null" : uesrCourseRelation.getId()));

		boolean result = false;

		if (uesrCourseRelation == null) {
			return true;
		}

		uesrCourseRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(uesrCourseRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + uesrCourseRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + uesrCourseRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UesrCourseRelation> uesrCourseRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (uesrCourseRelationList == null ? "null" : uesrCourseRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(uesrCourseRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UesrCourseRelation uesrCourseRelation : uesrCourseRelationList) {
			uesrCourseRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(uesrCourseRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + uesrCourseRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + uesrCourseRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UesrCourseRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UesrCourseRelation uesrCourseRelation = null;

		if (id == null) {
			return uesrCourseRelation;
		}

		try {
			uesrCourseRelation = (UesrCourseRelation) dao.get(UesrCourseRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return uesrCourseRelation;		
		}	
		  
    	   
		@Override
		public List<UesrCourseRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UesrCourseRelation> uesrCourseRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UesrCourseRelation>();
		}

		try {
			uesrCourseRelation = (List<UesrCourseRelation>) dao.getList(UesrCourseRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (uesrCourseRelation == null ? "null" : uesrCourseRelation.size()));
    
		return uesrCourseRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUesrCourseRelationIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUesrCourseRelationIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUesrCourseRelationIdByUidAndTypeAndTargetId(Long uid,Long type,Long targetId)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid,type,targetId  : " + uid+" , "+type+" , "+targetId );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
        id = (Long) dao.getMapping("getUesrCourseRelationIdByUidAndTypeAndTargetId", new Object[] {uid,type,targetId });
   } catch (DaoException e) {
			log.error(" get id wrong by uid,type,targetId  : " + uid+" , "+type+" , "+targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUesrCourseRelationIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUesrCourseRelationIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUesrCourseRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUesrCourseRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUesrCourseRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUesrCourseRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUesrCourseRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

