/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOrder;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOrderService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog((String)"order");
    @Autowired
    UserService userService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserMemberRelationService userMemberRelationService;

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by order_id  : " + orderId));
        }
        UserOrder userOrder = null;
        if (orderId == null) {
            return userOrder;
        }
        try {
            Long id = (Long)this.dao.getMapping("getIdByOrderId", new Object[]{orderId});
            log.info((Object)("the id =" + id));
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderId  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + orderId));
        }
        return userOrder;
    }

    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,buyType  : " + uid + " , " + buyType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        try {
            log.info((Object)("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner));
            UserOrder order = this.getOrderObjectByOrderId(indentCode);
            log.info((Object)("get order : " + order.toString()));
            if (!Integer.valueOf(1).equals(order.getStatus())) {
                log.info((Object)" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = this.userService.getObjectById(uid);
            block1 : switch (respCode) {
                case 1: {
                    status = 3;
                    log.info((Object)("lesson order : " + order.getId() + " completed "));
                    switch (order.getBuyType()) {
                        case 1: {
                            log.info((Object)"==========\u89e3\u9501\u8bfe\u7a0b\u903b\u8f91==========");
                            break block1;
                        }
                        case 2: {
                            log.info((Object)"==========\u89e3\u9501\u8bfe\u65f6\u903b\u8f91==========");
                            break block1;
                        }
                        case 3: {
                            log.info((Object)"==========\u8d2d\u4e70\u8bfe\u7a0b\u8d44\u6599\u903b\u8f91==========");
                            break block1;
                        }
                        case 4: {
                            log.info((Object)"==========\u8d2d\u4e70\u8bfe\u65f6\u8d44\u6599\u903b\u8f91==========");
                            break block1;
                        }
                        case 5: {
                            log.info((Object)"==========\u8d2d\u4e70\u6559\u6750\u8d44\u6599\u903b\u8f91==========");
                            break block1;
                        }
                        case 6: {
                            log.info((Object)"==========\u8d2d\u4e70\u4f1a\u5458\u903b\u8f91==========");
                            log.info((Object)" pay noticeBack ,type is member ");
                            Member member = this.memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;
                            List userMemberRelationIds = this.userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            if (CollectionUtils.isEmpty((Collection)userMemberRelationIds)) {
                                log.info((Object)(" user " + uid + " is not a member "));
                                log.info((Object)"==========\u5f00\u4f1a\u5458\u903b\u8f91==========");
                                startAt = now;
                            } else {
                                List userMemberRelations = this.userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    log.info((Object)(" user member endAt is " + UserOrderServiceImpl.getDate(userMemberRelation.getEndAt()) + " now is " + UserOrderServiceImpl.getDate(now)));
                                    if (userMemberRelation.getEndAt() >= endAt) {
                                        log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt));
                                        endAt = (long)userMemberRelation.getEndAt();
                                        continue;
                                    }
                                    log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt));
                                }
                                log.info((Object)("final end at member time is : " + endAt));
                                startAt = endAt;
                            }
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(Integer.valueOf(1));
                            userMemberRelation.setStartAt(startAt);
                            Date startDate = new Date(startAt);
                            Date endDate = DateUtils.addMonths((Date)startDate, (int)member.getPeriod().intValue());
                            endAt = endDate.getTime();
                            userMemberRelation.setEndAt(endAt);
                            log.info((Object)(" user " + uid + " member startAt = " + UserOrderServiceImpl.getDate(now) + " endAt = " + UserOrderServiceImpl.getDate(endAt)));
                            Long userMemberRelationId = this.userMemberRelationService.insert(userMemberRelation);
                            log.info((Object)(" user " + uid + " member id is = " + userMemberRelationId));
                            break block1;
                        }
                    }
                    break;
                }
                case 2: {
                    status = 2;
                    log.info((Object)("lesson order : " + order.getId() + " close "));
                }
            }
            if (1 == respCode) {
                log.info((Object)"==========\u652f\u4ed8\u6210\u529f\uff0c\u8bb0\u5f55\u63a8\u5e7f\u7edf\u8ba1\u4fe1\u606f==========");
            } else {
                log.info((Object)"==========\u652f\u4ed8\u5931\u8d25\uff0c\u4e0d\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f==========");
            }
            order.setStatus(status);
            order.setPayType(Integer.valueOf(payManner));
            order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            order.setPayAt(Long.valueOf(System.currentTimeMillis()));
            this.update(order);
            log.info((Object)"update order over");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            e.printStackTrace(System.out);
            log.error((Object)"error : ", (Throwable)e);
        }
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }
}

