/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserServiceImpl
extends BaseDaoServiceImpl
implements UserService {
    private static final Log log = LogFactory.getLog(UserServiceImpl.class);

    public Long insert(User user) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + user));
        if (user == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        user.setCreateAt(Long.valueOf(currentTimeMillis));
        user.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)user);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + user));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userList == null ? "null" : Integer.valueOf(userList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userList)) {
            return new ArrayList<User>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setCreateAt(Long.valueOf(currentTimeMillis));
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(User.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(User user) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (user == null ? "null" : user.getId())));
        boolean result = false;
        if (user == null) {
            return true;
        }
        user.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)user);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + user));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + user));
        }
        return result;
    }

    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userList == null ? "null" : Integer.valueOf(userList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userList.size()));
        return result;
    }

    public User getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        User user = null;
        if (id == null) {
            return user;
        }
        try {
            user = (User)this.dao.get(User.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return user;
    }

    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List user = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<User>();
        }
        try {
            user = this.dao.getList(User.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (user == null ? "null" : Integer.valueOf(user.size()))));
        return user;
    }

    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mobile  : " + mobile));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserIdByMobile", new Object[]{mobile});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mobile  : " + mobile));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserIdByMail(String mail) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by mail  : " + mail));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserIdByMail", new Object[]{mail});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by mail  : " + mail));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

