/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemberServiceImpl
extends BaseDaoServiceImpl
implements MemberService {
    private static final Log log = LogFactory.getLog(MemberServiceImpl.class);

    public Long insert(Member member) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + member));
        if (member == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        member.setCreateAt(Long.valueOf(currentTimeMillis));
        member.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)member);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + member));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Member> insertList(List<Member> memberList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (memberList == null ? "null" : Integer.valueOf(memberList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(memberList)) {
            return new ArrayList<Member>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Member member : memberList) {
            member.setCreateAt(Long.valueOf(currentTimeMillis));
            member.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(memberList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + memberList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Member.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Member member) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (member == null ? "null" : member.getId())));
        boolean result = false;
        if (member == null) {
            return true;
        }
        member.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)member);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + member));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + member));
        }
        return result;
    }

    public boolean updateList(List<Member> memberList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (memberList == null ? "null" : Integer.valueOf(memberList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(memberList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Member member : memberList) {
            member.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(memberList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + memberList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + memberList.size()));
        return result;
    }

    public Member getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Member member = null;
        if (id == null) {
            return member;
        }
        try {
            member = (Member)this.dao.get(Member.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return member;
    }

    public List<Member> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List member = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Member>();
        }
        try {
            member = this.dao.getList(Member.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (member == null ? "null" : Integer.valueOf(member.size()))));
        return member;
    }

    public List<Long> getMemberIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMemberIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMemberIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getMemberIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getMemberIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getMemberIdsByRecommend(Integer recommend, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by recommend,start,limit  : " + recommend + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMemberIdsByRecommend", new Object[]{recommend}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by recommend,start,limit  : " + recommend + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

