package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user_order")
public class
UserOrder implements Serializable, Comparable<UserOrder> {

    /**
     *
     */
    private static final long serialVersionUID = 3994439053252491264L;


    //支付成功
    public static final int PAY_SUCCESS = 1;

    //支付失败
    public static final int PAY_FAIL = 2;

    /**
     * 购买类型：专题
     */
    public static final Long TOPICS = 1L;
    private Long id;
    private Long uid;

    //订单号
    private String orderId;
    // 苹果内购订单号
    private String transactionId = "";
    private String receipt = "";
    private String voucherNo;
    private Long targetId;
    private Long payAt = 0L;
    private Long buyAt;

    //订单支付方式,
    public static final int PAYMANNER_1 = 1;//学习星
    public static final int PAYMANNER_2 = 2;//银行卡
    public static final int ALIPAY = 3;//支付宝
    public static final int WECHAT_PAY = 4;//微信支付
    public static final int InAppPurchase = 5;//内购
    public static final int PAYMANNER_6 = 6;//话费支付

    //支付方式
    private Integer payType;
    public static final int ORDER_LESSON = 1;    //订单类型为解锁科目
    public static final int ORDER_PERIOD = 2;    //订单类型为解锁
    public static final int ORDER_LPAPER = 3;    //订单类型为购买
    public static final int ORDER_PPAPER = 4;    //订单类型为购买
    public static final int ORDER_BPAPER = 5;    //订单类型为购买
    public static final int ORDER_MEMBER = 6;    //订单类型为购买会员
    public static final int ORDER_VOUCHER = 7;    //订单类型为体验卡

    private Integer buyType;
    private String address;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    public static final int WAITFORPAY = 1;    //订单状态为待支付
    public static final int CLOSED = 2;    //订单状态为已关闭
    public static final int COMPLETED = 3;    //订单状态为已完成
    public static final int PAY_VERIFY = 4;    //订单状态为已支付待验证

    private Integer status;
    private BigDecimal price = new BigDecimal(0);
    private BigDecimal originalPrice = new BigDecimal(0);

    public static final int OS_ANDROID = 1;    //支付系统为安卓
    public static final int OS_IOS = 2;    //支付系统为IOS

    private Integer Os;
    private Long subjectId;  //科目Id
    private Integer gradeDept;
    private Integer isFirst;
    private Integer isMain;
    private Long clerkId;
    private Long agentId;
    private Long regionalManagerId;
    private Long clazzId;
    private Integer personStatus;
    private Long schoolId;
    private Long teacherId;
    private String tradeName;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "order_id")
    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Column(name = "target_id")
    public Long getTargetId() {
        return targetId;
    }


    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    @Column(name = "pay_at")
    public Long getPayAt() {
        return payAt;
    }


    public void setPayAt(Long payAt) {
        this.payAt = payAt;
    }

    @Column(name = "buy_at")
    public Long getBuyAt() {
        return buyAt;
    }


    public void setBuyAt(Long buyAt) {
        this.buyAt = buyAt;
    }

    @Column(name = "pay_type")
    public Integer getPayType() {
        return payType;
    }


    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    @Column(name = "buy_type")
    public Integer getBuyType() {
        return buyType;
    }


    public void setBuyType(Integer buyType) {
        this.buyType = buyType;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "os")
    public Integer getOs() {
        return Os;
    }

    public void setOs(Integer os) {
        Os = os;
    }

    @Column(name = "voucher_no")
    public String getVoucherNo() {
        return voucherNo;
    }

    public void setVoucherNo(String voucherNo) {
        this.voucherNo = voucherNo;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "subject_id")
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    @Column(name = "is_first")
    public Integer getIsFirst() {
        return isFirst;
    }

    public void setIsFirst(Integer isFirst) {
        this.isFirst = isFirst;
    }

    @Column(name = "clerk_id")
    public Long getClerkId() {
        return clerkId;
    }

    public void setClerkId(Long clerkId) {
        this.clerkId = clerkId;
    }

    @Column(name = "person_status")
    public Integer getPersonStatus() {
        return personStatus;
    }

    public void setPersonStatus(Integer person_status) {
        this.personStatus = person_status;
    }

    @Column(name = "is_main")
    public Integer getIsMain() {
        return isMain;
    }

    public void setIsMain(Integer isMain) {
        this.isMain = isMain;
    }

    @Column(name = "school_id")
    public Long getSchoolId() {
        return schoolId;
    }

    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    @Column(name = "agent_id")
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    @Column(name = "regional_manager_id")
    public Long getRegionalManagerId() {
        return regionalManagerId;
    }

    public void setRegionalManagerId(Long regionalManagerId) {
        this.regionalManagerId = regionalManagerId;
    }

    @Column(name = "clazz_id")
    public Long getClazzId() {
        return clazzId;
    }

    public void setClazzId(Long clazzId) {
        this.clazzId = clazzId;
    }

    @Column(name = "teacher_id")
    public Long getTeacherId() {
        return teacherId;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    @Column(name = "trade_name")
    public String getTradeName() {
        return tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    @Column(name = "original_price")
    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    @Column(name = "transaction_id")
    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @Column(name = "receipt")
    public String getReceipt() {
        return receipt;
    }

    public void setReceipt(String receipt) {
        this.receipt = receipt;
    }

    @Override
    public int compareTo(UserOrder o) {
        Long payAt = o.getPayAt();
        Long thisPayAt = this.getPayAt();

        //对字段进行升序，如果欲降序可采用before方法
        if (thisPayAt > payAt) {
            return -1;
        }
        if (thisPayAt < payAt) {
            return 1;
        }
        return 0;

    }
}

