package com.ptteng.sca.academy.user.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.UserVideo;
import com.ptteng.academy.user.service.UserVideoService;

import java.util.List;
import java.util.Map;

public class UserVideoSCAClient implements UserVideoService {

    private UserVideoService userVideoService;

    public UserVideoService getUserVideoService() {
        return userVideoService;
    }

    public void setUserVideoService(UserVideoService userVideoService) {
        this.userVideoService = userVideoService;
    }

    @Override
    public Long insert(UserVideo userVideo) throws ServiceException, ServiceDaoException {
        return userVideoService.insert(userVideo);
    }

    @Override
    public List<UserVideo> insertList(List<UserVideo> userVideoList) throws ServiceException, ServiceDaoException {
        return userVideoService.insertList(userVideoList);
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        return userVideoService.delete(id);
    }

    @Override
    public boolean update(UserVideo userVideo) throws ServiceException, ServiceDaoException {
        return userVideoService.update(userVideo);
    }

    @Override
    public boolean updateList(List<UserVideo> userVideoList) throws ServiceException, ServiceDaoException {
        return userVideoService.updateList(userVideoList);
    }

    @Override
    public UserVideo getObjectById(Long id) throws ServiceException, ServiceDaoException {
        return userVideoService.getObjectById(id);
    }

    @Override
    public List<UserVideo> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        return userVideoService.getObjectsByIds(ids);
    }

    @Override
    public List<Long> getUserVideoIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return userVideoService.getUserVideoIdsByUserId(userId, 0, limit);
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return userVideoService.getIdsByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return userVideoService.getIdsByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public boolean fakeDelete(Class aClass, Long aLong) throws ServiceException, ServiceDaoException {
        return userVideoService.fakeDelete(aClass, aLong);
    }

    @Override
    public void deleteList(Class aClass, List<Long> list) throws ServiceException, ServiceDaoException {
        userVideoService.deleteList(aClass, list);
    }
}
