package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "member")
public class Member implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4087060092342286336L;

    public static final Integer IS_RECOMMEND = 1;
    public static final Integer NOT_RECOMMEND = 2;
    public static final Integer STATUS_UP = 1;
    public static final Integer STATUS_DOWN = 2;

    public static final String NOT_MEMBER = "非会员";
    public static final String EXPRIED_MEMBER = "过期会员";

    public static final Integer PLATFORM_DOUNIXUE = 1;
    public static final Integer PLATFORM_JS_MOBILE = 2;

    public static final Integer MAIN_PROD = 1;
    public static final Integer NOT_MAIN_PROD = 2;


    private Long id;

    private String name;

    private BigDecimal period;

    private BigDecimal price;
    private BigDecimal iosPrice;
    private BigDecimal discountPrice;
    private BigDecimal iosDiscountPrice;

    private Integer status;

    private Integer recommend;
    private Integer memberCode;

    private String logo;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;

    private Integer orderBy;

    private Integer platform = PLATFORM_DOUNIXUE;

    private Integer cacheAmountLimit;

    /*9期新增*/
    private Long subjectId;  //科目Id
    private Integer gradeDept;   // 年级部
    private Integer type;  //会员类型，用以区分9期前后的会员

    /*CRM*/
    private Integer isMain = NOT_MAIN_PROD;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "period")
    public BigDecimal getPeriod() {
        return period;
    }


    public void setPeriod(BigDecimal period) {
        this.period = period;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }


    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "recommend")
    public Integer getRecommend() {
        return recommend;
    }


    public void setRecommend(Integer recommend) {
        this.recommend = recommend;
    }

    @Column(name = "logo")
    public String getLogo() {
        return logo;
    }


    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    @Column(name = "orderBy")
    public Integer getOrderBy() {
        return orderBy;
    }


    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "ios_price")
    public BigDecimal getIosPrice() {
        return iosPrice;
    }

    public void setIosPrice(BigDecimal iosPrice) {
        this.iosPrice = iosPrice;
    }

    @Column(name = "discount_price")
    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    @Column(name = "ios_discount_price")
    public BigDecimal getIosDiscountPrice() {
        return iosDiscountPrice;
    }

    public void setIosDiscountPrice(BigDecimal iosDiscountPrice) {
        this.iosDiscountPrice = iosDiscountPrice;
    }

    @Column(name = "platform")
    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "cache_amount_limit")
    public Integer getCacheAmountLimit() {
        return cacheAmountLimit;
    }

    public void setCacheAmountLimit(Integer cacheAmountLimit) {
        this.cacheAmountLimit = cacheAmountLimit;
    }

    @Column(name = "subject_id")
    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "is_main")
    public Integer getIsMain() {
        return isMain;
    }

    public void setIsMain(Integer isMain) {
        this.isMain = isMain;
    }

}

