package com.ptteng.academy.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserMemberRelationService extends BaseDaoService {


    public Long insert(UserMemberRelation userMemberRelation) throws ServiceException, ServiceDaoException;


    public List<UserMemberRelation> insertList(List<UserMemberRelation> userMemberRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserMemberRelation userMemberRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserMemberRelation> userMemberRelationList) throws ServiceException, ServiceDaoException;


    public UserMemberRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserMemberRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserMemberRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserMemberRelationIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserMemberRelationIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserMemberRelationIdsByUidAndStatusAndSubjectId(Long uid, Integer status, Long subjectId,
                                                                         Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserMemberRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

