package com.ptteng.academy.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.AccountMember;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AccountMemberService extends BaseDaoService {


    public Long insert(AccountMember accountMember) throws ServiceException, ServiceDaoException;


    public List<AccountMember> insertList(List<AccountMember> accountMemberList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(AccountMember accountMember) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<AccountMember> accountMemberList) throws ServiceException, ServiceDaoException;


    public AccountMember getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<AccountMember> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAccountMemberIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countAccountMemberIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getAccountMemberIdsByAccountId(Long accountId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


}

