package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5339042769544866816L;

    public static final Integer STATUS_NORMAL = 1;

    public static final Integer STATUS_OFF = 2;

    public static final Integer NO_SIGN = 0;

    public static final Integer SIGN = 1;

    public static final Integer HOLLOW_STATUS_NEVER = 1;

    public static final Integer HOLLOW_STATUS_USED = 2;
    //公告状态未读
    public static final Integer NOTICE_UNREAD = 1;
    //公告状态已读
    public static final Integer NOTICE_READ = 2;

    // 邀请下载页面未查看
    public static final Integer RECOMMEND_UNVISTIED = 1;
    // 邀请下载页面已查看
    public static final Integer RECOMMEND_VISITED = 2;

    /**
     * 小学
     */
    public static final int PRIMARY_SCHOOL = 4;

    /**
     * 初中
     */
    public static final int JUNIOR_HIGH_SCHOOL = 1;

    /**
     * 高中
     */
    public static final int HIGH_SCHOOL = 2;

    /**
     * 留学
     */
    public static final int STUDY_ABROAB = 3;

    /**
     * 是否
     * 0--否
     * 1--是
     */
    public static final int IS_NOT_MEMBER = 2;
    public static final int IS_MEMBER = 1;
    public static final int IS_EXPRIED_MEMBER = 0;

    public static final int POST_UNREAD = 1;
    public static final int POST_READ = 2;

    public static final Integer dept_junior_high = 1;
    public static final Integer dept_senior_high = 2;
    public static final Integer dept_study_abroad = 3;

    /* from course start */
    public static final Integer allGrade = 7;

    public static final Integer SPEND = 1;
    public static final Integer NO_SPEND = 2;

    /**
     * 用户类型：老师
     */
    public static final Integer TEACHER = 1;

    /**
     * 用户类型：学生
     */
    public static final Integer STUDENT = 2;

    public String platform;
    private String deviceToken;
    private String tabletDeviceToken;
    private Long id;
    private String mobile;
    private String mail;
    private String pwd;
    private String alias;
    private String name;
    private String img;
    private String payPwd;
    private Integer grade;
    private Integer gradeDept;
    private Long schoolId;
    private String schoolName;
    private String className;
    private String location;
    private Long score = 0L;
    private Long registerAt;
    private Long lastLoginAt;
    private Integer status;
    private Integer wrongCount = 0;
    private Integer consecutive = 0;
    private Integer signHighest = 0;
    private Integer signTotal = 0;
    private Integer sign = 2;
    private Integer hollowStatus = 1;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    private String os;
    /**
     * 小学部公告是否已读
     */
    private Integer isRead = 1;

    /**
     * 初中部公告是否已读
     */
    private Integer isJuniorRead = 1;

    /**
     * 高中部公告是否已读
     */
    private Integer isHighRead = 1;

    /**
     * 留学部公告是否已读
     */
    private Integer isStudyAbroadRead = 1;

    private Integer isVisit;
    private Integer isMember;
    private Integer poststatus;
    private String token;
    private String appToken;
    private String tabletToken;
    private String areaCode;

    // 邀请注册相关
    private String invitationCode;
    private Integer invitationCodeStatus = STATUS_NORMAL;
    private Long recommendId;
    private Integer recommendCount = 0;

    // 推广统计相关
    private Integer spendStatus = NO_SPEND;
    private BigDecimal iosAmount = BigDecimal.ZERO;
    private BigDecimal androidAmount = BigDecimal.ZERO;
    private Integer recommendFlag = STATUS_OFF;

    private Integer videoWatchTimes = 0;
    private Integer userType;
    public static Integer teacher = 1;
    public static Integer student = 2;
    //用户登录次数
    public Integer loginTimes = 0;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "mail")
    public String getMail() {
        return mail;
    }


    public void setMail(String mail) {
        this.mail = mail;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "alias")
    public String getAlias() {
        return alias;
    }


    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "pay_pwd")
    public String getPayPwd() {
        return payPwd;
    }


    public void setPayPwd(String payPwd) {
        this.payPwd = payPwd;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }


    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "school_id")
    public Long getSchoolId() {
        return schoolId;
    }


    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    @Transient
    public String getSchoolName() {
        return schoolName;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName;
    }

    @Column(name = "class_name")
    public String getClassName() {
        return className;
    }


    public void setClassName(String className) {
        this.className = className;
    }

    @Column(name = "location")
    public String getLocation() {
        return location;
    }


    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name = "score")
    public Long getScore() {
        return score;
    }


    public void setScore(Long score) {
        this.score = score;
    }

    @Column(name = "register_at")
    public Long getRegisterAt() {
        return registerAt;
    }


    public void setRegisterAt(Long registerAt) {
        this.registerAt = registerAt;
    }

    @Column(name = "last_login_at")
    public Long getLastLoginAt() {
        return lastLoginAt;
    }


    public void setLastLoginAt(Long lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "wrong_count")
    public Integer getWrongCount() {
        return wrongCount;
    }


    public void setWrongCount(Integer wrongCount) {
        this.wrongCount = wrongCount;
    }

    @Column(name = "consecutive")
    public Integer getConsecutive() {
        return consecutive;
    }


    public void setConsecutive(Integer consecutive) {
        this.consecutive = consecutive;
    }

    @Column(name = "sign_highest")
    public Integer getSignHighest() {
        return signHighest;
    }


    public void setSignHighest(Integer signHighest) {
        this.signHighest = signHighest;
    }

    @Column(name = "sign")
    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    @Column(name = "sign_total")
    public Integer getSignTotal() {
        return signTotal;
    }

    public void setSignTotal(Integer signTotal) {
        this.signTotal = signTotal;
    }

    @Column(name = "hollow_status")
    public Integer getHollowStatus() {
        return hollowStatus;
    }

    public void setHollowStatus(Integer hollowStatus) {
        this.hollowStatus = hollowStatus;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Transient
    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "is_read")
    public Integer getIsRead() {
        return isRead;
    }


    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    @Column(name = "is_member")
    public Integer getIsMember() {
        return isMember;
    }


    public void setIsMember(Integer isMember) {
        this.isMember = isMember;
    }

    @Column(name = "poststatus")
    public Integer getPoststatus() {
        return poststatus;
    }


    public void setPoststatus(Integer poststatus) {
        this.poststatus = poststatus;
    }

    @Column(name = "platform")
    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Column(name = "device_token")
    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    @Column(name = "tablet_device_token")
    public String getTabletDeviceToken() {
        return tabletDeviceToken;
    }

    public void setTabletDeviceToken(String tabletDeviceToken) {
        this.tabletDeviceToken = tabletDeviceToken;
    }

    @Column(name = "token")
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Column(name = "area_code")
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "app_token")
    public String getAppToken() {
        return appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Column(name = "invitation_code")
    public String getInvitationCode() {
        return invitationCode;
    }

    public void setInvitationCode(String invitationCode) {
        this.invitationCode = invitationCode;
    }

    @Column(name = "recommend_id")
    public Long getRecommendId() {
        return recommendId;
    }

    public void setRecommendId(Long recommendId) {
        this.recommendId = recommendId;
    }

    @Column(name = "recommend_count")
    public Integer getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Integer recommendCount) {
        this.recommendCount = recommendCount;
    }

    @Column(name = "spend_status")
    public Integer getSpendStatus() {
        return spendStatus;
    }

    public void setSpendStatus(Integer spendStatus) {
        this.spendStatus = spendStatus;
    }

    @Column(name = "ios_amount")
    public BigDecimal getIosAmount() {
        return iosAmount;
    }

    public void setIosAmount(BigDecimal iosAmount) {
        this.iosAmount = iosAmount;
    }

    @Column(name = "android_amount")
    public BigDecimal getAndroidAmount() {
        return androidAmount;
    }

    public void setAndroidAmount(BigDecimal androidAmount) {
        this.androidAmount = androidAmount;
    }

    @Column(name = "recommend_flag")
    public Integer getRecommendFlag() {
        return recommendFlag;
    }

    public void setRecommendFlag(Integer recommendFlag) {
        this.recommendFlag = recommendFlag;
    }

    @Column(name = "is_visit")
    public Integer getIsVisit() {
        return isVisit;
    }

    public void setIsVisit(Integer isVisit) {
        this.isVisit = isVisit;
    }

    @Column(name = "video_watch_times")
    public Integer getVideoWatchTimes() {
        return videoWatchTimes;
    }

    public void setVideoWatchTimes(Integer videoWatchTimes) {
        this.videoWatchTimes = videoWatchTimes;
    }

    @Column(name = "user_type")
    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    @Column(name = "login_times")
    public Integer getLoginTimes() {
        return loginTimes;
    }

    public void setLoginTimes(Integer loginTimes) {
        this.loginTimes = loginTimes;
    }
    @Column(name = "invitation_code_status")
    public Integer getInvitationCodeStatus() {
        return invitationCodeStatus;
    }

    public void setInvitationCodeStatus(Integer invitationCodeStatus) {
        this.invitationCodeStatus = invitationCodeStatus;
    }

    @Column(name = "tablet_token")
    public String getTabletToken() {
        return tabletToken;
    }

    public void setTabletToken(String tabletToken) {
        this.tabletToken = tabletToken;
    }

    @Column(name = "is_junior_read")
    public Integer getIsJuniorRead() {
        return isJuniorRead;
    }

    @Column(name = "is_high_read")
    public Integer getIsHighRead() {
        return isHighRead;
    }

    @Column(name = "is_study_abroad_read")
    public Integer getIsStudyAbroadRead() {
        return isStudyAbroadRead;
    }

    public void setIsJuniorRead(Integer isJuniorRead) {
        this.isJuniorRead = isJuniorRead;
    }

    public void setIsHighRead(Integer isHighRead) {
        this.isHighRead = isHighRead;
    }

    public void setIsStudyAbroadRead(Integer isStudyAbroadRead) {
        this.isStudyAbroadRead = isStudyAbroadRead;
    }
}


