package com.ptteng.academy.user.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.OrderStatistics;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface OrderStatisticsService extends BaseDaoService {


    public Long insert(OrderStatistics orderStatistics) throws ServiceException, ServiceDaoException;


    public List<OrderStatistics> insertList(List<OrderStatistics> orderStatisticsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(OrderStatistics orderStatistics) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<OrderStatistics> orderStatisticsList) throws ServiceException, ServiceDaoException;


    public OrderStatistics getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<OrderStatistics> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @Description 根据staticAt获取统计id
     * @Author: PeiyuFeng
     * @Time 2017/5/29 23:22
     */
    public Long getOrderStatisticsIdByStaticAt(Long staticAt) throws ServiceException, ServiceDaoException;

    public Long getOrderStatisticsIdByStaticAtAndSchoolId(Long staticAt, Long schoolId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getOrderStatisticsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countOrderStatisticsIds() throws ServiceException, ServiceDaoException;


}

