package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user_member_relation")
public class UserMemberRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1224374128426689536L;

    /**
     * 一个月（31天）时间戳
     */
    public static final Long MONTH_TIMESTAMPS = 86400000L * 31;
    public static final Long DAY_TIMESTAMPS = 86400000L;

    private Long id;


    private Long uid;


    private String name;


    private BigDecimal period;


    private BigDecimal price;


    private Long startAt;


    private Long endAt;


    private Integer status;


    private Long couponId;

    private Integer cacheAmountLimit = 5;

    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "period")
    public BigDecimal getPeriod() {
        return period;
    }


    public void setPeriod(BigDecimal period) {
        this.period = period;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }


    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }


    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "coupon_id")
    public Long getCouponId() {
        return couponId;
    }


    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "cache_amount_limit")
    public Integer getCacheAmountLimit() {
        return cacheAmountLimit;
    }

    public void setCacheAmountLimit(Integer cacheAmountLimit) {
        this.cacheAmountLimit = cacheAmountLimit;
    }
}

