package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user_order")
public class UserOrder implements Serializable, Comparable<UserOrder> {

    /**
     *
     */
    private static final long serialVersionUID = 3994439053252491264L;


    //支付成功
    public static final int PAY_SUCCESS = 1;

    //支付失败
    public static final int PAY_FAIL = 2;


    private Long id;


    private Long uid;

    //订单号
    private String orderId;


    private Long targetId;


    private Long payAt = 0L;


    private Long buyAt;

   //订单支付方式,
    public static final int PAYMANNER_1 = 1;//学习星
    public static final int PAYMANNER_2 = 2;//银行卡
    public static final int PAYMANNER_3 = 3;//支付宝
    public static final int PAYMANNER_4 = 4;//微信支付
    public static final int PAYMANNER_5 = 5;//内购
    public static final int PAYMANNER_6 = 6;//话费支付

    //支付方式
    private Integer payType;


    public static final int ORDER_LESSON = 1;    //订单类型为解锁科目
    public static final int ORDER_PERIOD = 2;    //订单类型为解锁
    public static final int ORDER_LPAPER = 3;    //订单类型为购买
    public static final int ORDER_PPAPER = 4;    //订单类型为购买
    public static final int ORDER_BPAPER = 5;    //订单类型为购买
    public static final int ORDER_MEMBER = 6;    //订单类型为购买会员


    private Integer buyType;


    private String address;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    public static final int WAITFORPAY = 1;    //订单状态为待支付
    public static final int CLOSED = 2;    //订单状态为已关闭
    public static final int COMPLETED = 3;    //订单状态为已完成

    private Integer status;

    private BigDecimal price = new BigDecimal(0);

    public static final int OS_ANDROID = 1;    //支付系统为安卓
    public static final int OS_IOS = 2;    //支付系统为IOS

    private Integer Os;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "order_id")
    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    @Column(name = "target_id")
    public Long getTargetId() {
        return targetId;
    }


    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    @Column(name = "pay_at")
    public Long getPayAt() {
        return payAt;
    }


    public void setPayAt(Long payAt) {
        this.payAt = payAt;
    }

    @Column(name = "buy_at")
    public Long getBuyAt() {
        return buyAt;
    }


    public void setBuyAt(Long buyAt) {
        this.buyAt = buyAt;
    }

    @Column(name = "pay_type")
    public Integer getPayType() {
        return payType;
    }


    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    @Column(name = "buy_type")
    public Integer getBuyType() {
        return buyType;
    }


    public void setBuyType(Integer buyType) {
        this.buyType = buyType;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "price")
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "os")
    public Integer getOs() {
        return Os;
    }

    public void setOs(Integer os) {
        Os = os;
    }

    @Override
    public int compareTo(UserOrder o) {
        Long payAt = o.getPayAt();
        Long thisPayAt = this.getPayAt();

        //对字段进行升序，如果欲降序可采用before方法
        if (thisPayAt > payAt) {
            return -1;
        }
        if (thisPayAt < payAt) {
            return 1;
        }
        return 0;

    }
}

