package com.ptteng.academy.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5339042769544866816L;


    public static final Integer STATUS_NORMAL = 1;

    public static final Integer STATUS_OFF = 2;

    public static final Integer NO_SIGN = 0;

    public static final Integer SIGN = 1;

    public static final Integer HOLLOW_STATUS_NEVER = 1;

    public static final Integer HOLLOW_STATUS_USED = 2;
    //公告状态未读
    public static final Integer NOTICE_UNREAD = 1;
    //公告状态已读
    public static final Integer NOTICE_READ = 2;

    /**
     * 是否
     * 0--否
     * 1--是
     */
    public static final int IS_NOT_MEMBER = 2;
    public static final int IS_MEMBER = 1;
    public static final int IS_EXPRIED_MEMBER = 0;

    public static final int POST_UNREAD = 1;
    public static final int POST_READ = 2;

    /* from course start */
    public static final Integer allGrade = 7;

    public String platform;

    private String deviceToken;


    private Long id;


    private String mobile;


    private String mail;


    private String pwd;


    private String alias;


    private String name;


    private String img;


    private String payPwd;


    private Integer grade;

    private Long schoolId;

    private String schoolName;

    private String className;


    private String location;


    private Long score = 0L;


    private Long registerAt;


    private Long lastLoginAt;


    private Integer status;


    private Integer wrongCount = 0;


    private Integer consecutive = 0;


    private Integer signHighest = 0;


    private Integer signTotal = 0;


    private Integer sign = 2;


    private Integer hollowStatus = 1;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    private String os;

    private Integer isRead;
    private Integer isMember;
    private Integer poststatus;
    private String token;
    private String areaCode;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "mail")
    public String getMail() {
        return mail;
    }


    public void setMail(String mail) {
        this.mail = mail;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "alias")
    public String getAlias() {
        return alias;
    }


    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "pay_pwd")
    public String getPayPwd() {
        return payPwd;
    }


    public void setPayPwd(String payPwd) {
        this.payPwd = payPwd;
    }

    @Column(name = "grade")
    public Integer getGrade() {
        return grade;
    }


    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    @Column(name = "school_id")
    public Long getSchoolId() {
        return schoolId;
    }


    public void setSchoolId(Long schoolId) {
        this.schoolId = schoolId;
    }

    @Transient
    public String getSchoolName() {
        return schoolName;
    }

    public void setSchoolName(String schoolName) {
        this.schoolName = schoolName;
    }

    @Column(name = "class_name")
    public String getClassName() {
        return className;
    }


    public void setClassName(String className) {
        this.className = className;
    }

    @Column(name = "location")
    public String getLocation() {
        return location;
    }


    public void setLocation(String location) {
        this.location = location;
    }

    @Column(name = "score")
    public Long getScore() {
        return score;
    }


    public void setScore(Long score) {
        this.score = score;
    }

    @Column(name = "register_at")
    public Long getRegisterAt() {
        return registerAt;
    }


    public void setRegisterAt(Long registerAt) {
        this.registerAt = registerAt;
    }

    @Column(name = "last_login_at")
    public Long getLastLoginAt() {
        return lastLoginAt;
    }


    public void setLastLoginAt(Long lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "wrong_count")
    public Integer getWrongCount() {
        return wrongCount;
    }


    public void setWrongCount(Integer wrongCount) {
        this.wrongCount = wrongCount;
    }

    @Column(name = "consecutive")
    public Integer getConsecutive() {
        return consecutive;
    }


    public void setConsecutive(Integer consecutive) {
        this.consecutive = consecutive;
    }

    @Column(name = "sign_highest")
    public Integer getSignHighest() {
        return signHighest;
    }


    public void setSignHighest(Integer signHighest) {
        this.signHighest = signHighest;
    }

    @Column(name = "sign")
    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    @Column(name = "sign_total")
    public Integer getSignTotal() {
        return signTotal;
    }

    public void setSignTotal(Integer signTotal) {
        this.signTotal = signTotal;
    }

    @Column(name = "hollow_status")
    public Integer getHollowStatus() {
        return hollowStatus;
    }

    public void setHollowStatus(Integer hollowStatus) {
        this.hollowStatus = hollowStatus;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Transient
    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }


    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "is_read")
    public Integer getIsRead() {
        return isRead;
    }


    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    @Column(name = "is_member")
    public Integer getIsMember() {
        return isMember;
    }


    public void setIsMember(Integer isMember) {
        this.isMember = isMember;
    }

    @Column(name = "poststatus")
    public Integer getPoststatus() {
        return poststatus;
    }


    public void setPoststatus(Integer poststatus) {
        this.poststatus = poststatus;
    }

    @Column(name = "platform")
    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Column(name = "device_token")
    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    @Column(name = "token")
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Column(name = "area_code")
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
}

