package com.ptteng.academy.admin.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.academy.admin.model.Window;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface WindowService extends BaseDaoService {


    public Long insert(Window window) throws ServiceException, ServiceDaoException;


    public List<Window> insertList(List<Window> windowList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Window window) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Window> windowList) throws ServiceException, ServiceDaoException;


    public Window getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Window> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getWindowIdByUserIdAndWindowId(Long userId, Long windowId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWindowIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countWindowIds() throws ServiceException, ServiceDaoException;


}

