package com.ptteng.academy.admin.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "school")
public class School implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 896793488245277696L;

    public static Integer LOGIN_NORMAL = 1;
    public static Integer LOGIN_RESTRICT = 2;

    private Long id;

    private Long clerkId;
    private String clerkName;
    private String clerkMobile;
    private String area;
    private String name;
    //(该校学生是否限制登录)监管状态
    private Integer status = 1;
    private Integer supervisionStatus = 1;
    private Integer gradeDept;
    private String gradeDeptStr;

    private Long indx;
    private String info;

    private Long province;
    private Long city;
    private Long county;

    private Long createBy;

    private Long updateBy;

    private Long updateAt;

    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    @Column(name = "province")
    public Long getProvince() {
        return province;
    }

    public void setProvince(Long province) {
        this.province = province;
    }

    @Column(name = "city")
    public Long getCity() {
        return city;
    }

    public void setCity(Long city) {
        this.city = city;
    }

    @Column(name = "county")
    public Long getCounty() {
        return county;
    }

    public void setCounty(Long county) {
        this.county = county;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "supervision_status")
    public Integer getSupervisionStatus() {
        return supervisionStatus;
    }

    public void setSupervisionStatus(Integer supervisionStatus) {
        this.supervisionStatus = supervisionStatus;
    }

    @Column(name = "grade_dept")
    public Integer getGradeDept() {
        return gradeDept;
    }

    public void setGradeDept(Integer gradeDept) {
        this.gradeDept = gradeDept;
    }

    @Column(name = "clerk_id")
    public Long getClerkId() {
        return clerkId;
    }

    public void setClerkId(Long clerkId) {
        this.clerkId = clerkId;
    }

    @Transient
    @Column(name = "clerk_name")
    public String getClerkName() {
        return clerkName;
    }

    public void setClerkName(String clerkName) {
        this.clerkName = clerkName;
    }

    @Transient
    @Column(name = "clerk_mobile")
    public String getClerkMobile() {
        return clerkMobile;
    }

    public void setClerkMobile(String clerkMobile) {
        this.clerkMobile = clerkMobile;
    }

    @Transient
    @Column(name = "area")
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    @Transient
    @Column(name = "indx")
    public Long getIndx() {
        return indx;
    }

    public void setIndx(Long indx) {
        this.indx = indx;
    }

    @Transient
    @Column(name = "grade_dept_str")
    public String getGradeDeptStr() {
        return gradeDeptStr;
    }

    public void setGradeDeptStr(String gradeDeptStr) {
        this.gradeDeptStr = gradeDeptStr;
    }

    @Transient
    @Column(name = "info")
    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

