package com.ptteng.academy.pc.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.Notice;
import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by liangxj on 2015/9/7.
 */
public class
DynamicUtil {


    public static Map<String, Object> getArticleListParam(Long startAt, Long endAt,
                                                          Integer type, String createBy, String title, Integer status) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("article");
        if (DataUtils.isNotNullOrEmpty(startAt)) {
            params.put(" article.update_at & >= ", "'" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(endAt)) {
            params.put(" article.update_at & <= ", "'" + endAt + "'");
        }
        if (type == null) {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {

            params.put(" article.type", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" article.status", status);

        }
        if (StringUtil.isNotEmpty(createBy)) {
            params.put("manager.id ", "article.create_by");
            params.put(" manager.name & like ", "'%" + createBy + "'");
            tables.add("manager");
        }


        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);


        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getDocumentList(Integer type, String title) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        params.put("status", 1);
        params.put("@order", "rank asc ,order_by asc, create_at desc ");
        params.put("@query", " id");

        params.put("@table", " document ");

        return params;
    }


    public static Map<String, Object> getVideoList(Integer type, String title, Integer grade, Integer subject) {
        Map<String, Object> params = new HashedMap();
        Set<String> tables = new HashSet();
        tables.add("video");
        if (DataUtils.isNotNullOrEmpty(title)) {
            params.put("video.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("video.type", "'" + type + "'");
        }

        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put("video.subject", "'" + subject + "'");
        }
        if (DataUtils.isNotNullOrEmpty(grade)) {
            tables.add("video_grade_relation as vgr");
            params.put("video.id", "vgr.video_id");
            params.put("vgr.grade", "'" + grade + "'");
        }

        if (Video.Type_Banner.equals(type)) {
            params.put("@order", " video.rank asc,video.order_by asc, video.create_at desc ");
        } else {
            params.put("@order", "video.rank asc, video.create_at desc ");
        }


        params.put("video.status", 1);
//		params.put("@order", " video.rank asc, video.order_by asc, video.create_at desc ");
        params.put("@query", " video.id");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type, Long userId) {
        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(name)) {
            params.put("name & like", " '%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(mail)) {
            params.put("mail & like", " '%" + mail + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(nick)) {
            params.put("nick & like", " '%" + nick + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(messageType)) {
            params.put("message_type", "'" + messageType + "'");
        }
        if (DataUtils.isNotNullOrEmpty(timeLow)) {
            params.put("create_at&>", "'" + timeLow + "'");
        }

        if (DataUtils.isNotNullOrEmpty(type) && DataUtils.isNotNullOrEmpty(userId)) {
            if (type == 1) {
                if (grade == 7) {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + "))");

                } else {
                    params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + ") or  (type=1 and grade = " + grade + "))");

                    System.out.println(grade);
                }

            } else {
                params.put("type", "'" + type + "'");
            }
        }

        if (DataUtils.isNotNullOrEmpty(timeHigh)) {
            params.put("create_at&<", "'" + timeHigh + "'");
        }
        params.put("up_down", 1);
        if (Message.Type_Help.equals(type)) {
            params.put("@order", "  sort asc ");

        } else {
            params.put("@order", "  publish_at desc ");

        }
        params.put("@query", " id");

        params.put("@table", " message ");
        return params;
    }

    public static Map<String, Object> getUserMessageList(Long targetId, Long userId, Integer userRead) {
        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(targetId)) {
            params.put("target_id", " '" + targetId + "'");
        }

        if (DataUtils.isNotNullOrEmpty(userId)) {
            params.put("user_id", " '" + userId + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userRead)) {
            params.put("user_read", " '" + userRead + "'");
        }

        params.put("@order", "  create_at desc ");
        params.put("@query", " id");

        params.put("@table", " user_message_relation ");

        return params;
    }

    //前台公告
    public static Map<String, Object> getNotice() {

        Map<String, Object> params = new HashMap<>();
        params.put("status", Notice.NOTICE_UP);
        params.put("@table", "notice");
        params.put("@query", "id");
        return params;
    }

    //得到会员套餐列表
    public static Map<String, Object> getMemberList(boolean count) {
        Map<String, Object> params = new HashedMap();
        params.put("status", Member.STATUS_UP);

        if (count) {
            params.put("@query", " count(id)");

        } else {
            params.put("@order", " recommend asc,  period asc ");
            params.put("@query", " id");
        }


        params.put("@table", " member ");

        return params;
    }

    //查询科目下面是否有上架视频
    public static Map<String, Object> getSubjectVideoStatus(Integer subject) {
        Map<String, Object> params = new HashedMap();
        params.put("subject", subject);
        params.put("status", Video.Status_Published);
        params.put("@query", " count(id)");
        params.put("@table", " video ");
        return params;
    }

    // 返回课程列表、按照id正序
    public static Map<String, Object> getPeriodList() {

        Map<String, Object> params = new HashMap<>();
        Set<String> tables = new HashSet<>();

        tables.add("period");

        params.put("@order", "period.id");
        params.put("@query", "period.id");

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    // 返回用户收藏（学习记录）列表
    public static Map<String, Object> getUserFavoriteRelationList() {

        Map<String, Object> params = new HashMap<>();
        Set<String> tables = new HashSet<>();

        tables.add("user_favorite_relation");

        params.put("@order", "user_favorite_relation.update_at");
        params.put("@query", "user_favorite_relation.id");

        return params;
    }


    // 搜索科目列表
    public static Map<String, Object> getSubjectList(String subjectName, Integer gradeDept, Integer status) {

        Map<String, Object> params = new HashedMap();
        if (DataUtils.isNotNullOrEmpty(subjectName)) {
            params.put(" subject_name & like", " '%" + subjectName + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(gradeDept)) {
            params.put("grade_dept", "'" + gradeDept + "'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", " '" + status + "'");
        }

        params.put("@order", "  sort asc ");
        params.put("@query", " id");

        params.put("@table", " subject ");

        return params;
    }

    public static Map<String, Object> getLessonList(String lessonName, String subjectIds, Integer status) {

        Map<String, Object> params = new HashedMap();

        if (DataUtils.isNotNullOrEmpty(lessonName)) {
            params.put("lesson_name & like", " '%" + lessonName + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(subjectIds)) {
            params.put("subject_id & in", "(" + subjectIds + ")");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", "'" + status + "'");
        }

        params.put("@order", "  sort asc, update_at desc");
        params.put("@query", " id");

        params.put("@table", " lesson ");
//        String s = SQLUtil.convert2Sql(params, 0, Integer.MAX_VALUE);
//
//        System.out.println("专题搜索sql：" + s);
        return params;
    }


    public static Map<String, Object> getUnitList(Integer mediaType) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(mediaType)) {

            params.put("media_type", "'" + mediaType + "'");
        }

        params.put("@order", " sort asc ");
        params.put("@query", "id");

        params.put("@table", " unit ");

        return params;

    }

    public static Map<String, Object> getTaskList(Integer status) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(status)) {

            params.put("status", "'" + status + "'");
        }
        params.put("@order", " sort asc ");
        params.put("@query", "id");
        params.put("@table", " task ");

        return params;
    }


}