package com.ptteng.academy.pc.controller;

/**
 * Created by ${zhangfan} on 2017/10/5.
 */
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.pc.util.OrderIdUtil;
import com.ptteng.academy.user.model.*;
import com.ptteng.academy.user.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
public class  UserOrderController {
    private static final Log orderlog = LogFactory.getLog("order");


    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMemberRelationService userMemberRelationService;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private MemberService memberService;
    @Autowired
    private CookieUtil cookieUtil;


    //新建订单
    @RequestMapping(value = "/a/u/order", method = RequestMethod.POST)
    public String createOrder(HttpServletRequest request, HttpServletResponse response,
                              ModelMap model, Long targetId, Integer type) throws Exception {
        Long oid = 0L;
        String name = "";
        Long relationId = 0L;
        Long lockedId = 0L;
        String paperPrice = "";

        BigDecimal price = new BigDecimal(0);
        Boolean lockStatus = false;
        List<Long> lessonPeriodIds = new ArrayList<>();
        //这种方法得不到user,原因是什么?
//        User user = (User) request.getAttribute("user");
////        Long uid = user.getId();
////        orderlog.info("get uid " + uid);

        Cookie[] cookies = request.getCookies();
        Map<String, String> maps = cookieUtil.getIdentity(request);
        Long uid = cookieUtil.getID(request);
        orderlog.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        orderlog.info("create order : targetId = " + targetId + " type = " + type);
        String mail = user.getMail();
        try {
            orderlog.info("==========参数校验==========");
            if (DataUtils.isNullOrEmpty(type) || DataUtils.isNullOrEmpty(targetId)) {
                orderlog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            orderlog.info("==========购买目标是否存在==========");
            if (UserOrder.ORDER_MEMBER == type) {

                //判断用户是否是会员，如果不是，才能购买(已被续费替代)
//                if(User.IS_MEMBER== user.getMember()){
//                    model.addAttribute("code", -6003);
//                    return "/common/success";
//                }else {
                Member member = memberService.getObjectById(targetId);
                if (null == member) {
                    orderlog.info("no such member");
                    model.addAttribute("code", -6008);
                    return "/common/success";
                } else {

                    Boolean discountStatus = false;
                    BigDecimal discount = BigDecimal.ZERO;

                    //是否购买过会员
                    List<Long> orderIds = userOrderService.getUserOrderIdsByUidAndBuyTypeAndStatus(uid, UserOrder.ORDER_MEMBER, UserOrder.COMPLETED, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(orderIds)) {
                        orderlog.info(" get user memberList ids ,size is 0 ");

//                        Long recommendId = user.getRecommendId();
//                        if(null == recommendId){
//                            orderlog.info("user have no recommend user ");
//                        }else {
//                            orderlog.info("recommend id is : " + recommendId);
//                            discountStatus = true;
//                            UserRecommend recommendUser = userRecommendService.getObjectById(recommendId);
//                            discount = recommendUser.getDiscount();
//                        }

                    } else {
                        orderlog.info(" user almost buy member , no discount ");
                    }

                    if (discountStatus) {
                        price = member.getPrice().multiply(discount).divide(BigDecimal.TEN);
                        //保留2位小数
                        price = price.setScale(2, BigDecimal.ROUND_HALF_UP);
                    } else {
                        price = member.getPrice();
                    }

                    name = member.getName();
                }

//                }
            }
            orderlog.info("order price : " + price + " name : " + name);

            orderlog.info("==========检验是否买过本资料==========");
            Long orderId = userOrderService.getUserOrderIdsByUidAndBuyTypeAndTargetId(uid, type, targetId);
            if (null != orderId && type != UserOrder.ORDER_MEMBER) {
                orderlog.info("already pay the order");
                model.addAttribute("code", -4015);
                return "/common/success";
            }

            orderlog.info("==========生成订单号==========");
            String order_Id = OrderIdUtil.generateOrderId();
            orderlog.info(order_Id);

            //注释掉重复订单验证,否则报错
//            while (null != userOrderService.getOrderObjectByOrderId(order_Id)) {
//                order_Id = OrderIdUtil.generateOrderId();
//            }
//            if (null != userOrderService.getOrderObjectByOrderId(order_Id)) {
//                order_Id = OrderIdUtil.generateOrderId();
//            }
            orderlog.info("orderNo is " + order_Id);

            orderlog.info("==========新建订单==========");
            UserOrder order = new UserOrder();
            order.setOrderId(order_Id);
            order.setUid(uid);
            order.setTargetId(targetId);
            order.setBuyAt(System.currentTimeMillis());
            order.setBuyType(type);
            order.setStatus(UserOrder.WAITFORPAY);
            order.setPrice(price);
            order.setAddress(mail);

            oid = userOrderService.insert(order);
            orderlog.info("create order success , oid : " + oid);


            model.addAttribute("code", 0);
            model.addAttribute("oid", oid);
            model.addAttribute("orderNo", order_Id);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("create order error, uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/academy-user-service/userOrder/json/createOrder";
    }

    //保存支付方式
    @RequestMapping(value = "/a/u/order/pay/{oid}", method = RequestMethod.PUT)
    public String updatePayWay(HttpServletRequest request, HttpServletResponse response,
                               ModelMap model, @PathVariable Long oid, Integer payWay) throws Exception {
        String subject = "";
        String body = "";

        orderlog.info("save order : " + oid + " payment type : " + payWay);

//        User user = (User) request.getAttribute("user");
//        Long uid = user.getId();
        Cookie[] cookies = request.getCookies();
        Map<String, String> maps = cookieUtil.getIdentity(request);
        Long uid = cookieUtil.getID(request);
        orderlog.info("get uid " + uid);
        User user = userService.getObjectById(uid);

        orderlog.info("get uid " + uid);

        try {
            if (UserOrder.PAYMANNER_2 != payWay
                    && UserOrder.PAYMANNER_3 != payWay
                    && UserOrder.PAYMANNER_4 != payWay
                    && UserOrder.PAYMANNER_5 != payWay) {
                orderlog.info("illegal payWay");
                model.addAttribute("code", -4017);
                return "/common/success";
            }

            orderlog.info("==========检验是否拥有本订单==========");
            UserOrder userOrder = userOrderService.getObjectById(oid);
            if (null == userOrder) {
                orderlog.info("already pay the order");
                model.addAttribute("code", -4015);
                return "/common/success";
            }

            if (!uid.equals(userOrder.getUid())) {
                orderlog.info("not your order");
                model.addAttribute("code", -4016);
                return "/common/success";
            }

            orderlog.info("==========修改支付方式==========");
            userOrder.setPayType(payWay);
            userOrderService.update(userOrder);
            orderlog.info("update payment success");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("update pay way error, oid is  " + oid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //保存支付结果
    @RequestMapping(value = "/a/u/order/result/{oid}", method = RequestMethod.PUT)
    public String updateResult(HttpServletRequest request, HttpServletResponse response,
                               ModelMap model, @PathVariable Long oid, Integer result) throws Exception {

        orderlog.info("save order : " + oid + " pay result : " + result);

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        orderlog.info("get uid " + uid);

        try {
            if (null == result) {
                orderlog.info("null result");
                model.addAttribute("code", -4045);
                return "/common/success";
            }

            if (UserOrder.PAY_SUCCESS != result && UserOrder.PAY_FAIL != result) {
                orderlog.info("illegal result");
                model.addAttribute("code", -4018);
                return "/common/success";
            }

            orderlog.info("==========检验是否拥有本订单==========");
            UserOrder userOrder = userOrderService.getObjectById(oid);
            if (null == userOrder) {
                orderlog.info("no such order");
                model.addAttribute("code", -3007);
                return "/common/success";
            }

            if (!uid.equals(userOrder.getUid())) {
                orderlog.info("not your order");
                model.addAttribute("code", -4016);
                return "/common/success";
            }

            orderlog.info("==========支付结果==========");
            if (null == userOrder.getPayType()) {
                orderlog.info("order payType is null");
                model.addAttribute("code", -3008);
                return "/common/success";
            }

            if (UserOrder.WAITFORPAY != userOrder.getStatus()) {
                orderlog.info("close or already pay order");
                model.addAttribute("code", -3009);
                return "/common/success";
            }

            orderlog.info(" /pay/check indentCode =  " + userOrder.getOrderId());


            // 如果是待支付，查银行
            Integer payManner = userOrder.getPayType();//支付方式
            orderlog.info("  payManner = " + payManner);

            switch (payManner) {

                case UserOrder.PAYMANNER_2: {
                    orderlog.info("==========银行卡==========");
                    break;
                }
                case UserOrder.PAYMANNER_3: {
                    orderlog.info("==========支付宝==========");

                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderlog.info("==========微信==========");

                    break;

                }
                default:
                    break;
            }

            //调支付回调方法
            userOrderService.noticeBack(userOrder.getOrderId(), result, userOrder.getPayType());

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            orderlog.error(t.getMessage());
            orderlog.error("update order result error, oid is  " + oid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 获取订单详情
     * @param request
     * @param response
     * @param model
     * @param oid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/order/{oid}", method = RequestMethod.GET)
    public String getOrderJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable String oid)
            throws Exception {

        orderlog.info("get data : id= " + oid);
        try {

            UserOrder userOrder = userOrderService.getOrderObjectByOrderId(oid);
            orderlog.info("get userOrder data is " + userOrder);

            if (userOrder != null){

                model.addAttribute("code", 0);

                model.addAttribute("userOrder", userOrder);
            }else {

                model.addAttribute("code",-14002);
                return "/data/json";

            }

        } catch (Throwable t) {
            t.printStackTrace();
            orderlog.error(t.getMessage());
            orderlog.error("get userOrder error,id is  " + oid);
            model.addAttribute("code", -100000);
        }

        return "/academy-user-service/userOrder/json/userOrderDetailJson";
    }

    public static void main(String[] a) {

    }

}


