package com.ptteng.academy.pc.controller;


import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.pc.util.VideoAndVoiceUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@Controller
public class TaskController {

    private static final Log log = LogFactory.getLog("task");

    @Autowired
    private TaskService taskService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private AnswerService answerService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;

    /**
     * 获得任务详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/task/{id}", method = RequestMethod.GET)
    public String getTaskJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);


        Integer isFavorite = null;

        Task task = null;
        try {
            task = taskService.getObjectById(id);
            if (null == task) {
                model.addAttribute("code", -7000);
                return "/common/success";
            }

            // 查找是否已经有该条记录，不存在就新增、存在就更新

            /*
            * 存入学习记录
            * */
            String userIdStr = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            if (DataUtils.isNotNullOrEmpty(userIdStr)) {
                Long userId = Long.valueOf(userIdStr);

                Long relationIdR = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(id, userId, com.ptteng.academy.document.model.UserFavoriteRelation.TYPE_VIEW_RECORD, com.ptteng.academy.document.model.UserFavoriteRelation.TARGET_TYPE_TASK);

                  /*是否收藏*/
                Long relationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus(id, userId,
                        com.ptteng.academy.document.model.UserFavoriteRelation.TARGET_TYPE_TASK, com.ptteng.academy.document.model.UserFavoriteRelation.TYPE_COLLECTION, com.ptteng.academy.document.model.UserFavoriteRelation.STATUS_ACTIVE);

                if (DataUtils.isNotNullOrEmpty(relationId)) {
                    task.setIsFavorite(Task.favorite);
                }

                if (null == relationIdR) {

                    UserFavoriteRelation relation = new com.ptteng.academy.document.model.UserFavoriteRelation();
                    relation.setUid(userId);
                    relation.setTargetType(com.ptteng.academy.document.model.UserFavoriteRelation.TARGET_TYPE_TASK);
                    relation.setTargetId(id);
                    relation.setStatus(com.ptteng.academy.document.model.UserFavoriteRelation.STATUS_ACTIVE);
                    relation.setType(com.ptteng.academy.document.model.UserFavoriteRelation.TYPE_VIEW_RECORD);
                    relation.setCreateAt(System.currentTimeMillis());
                    relation.setUpdateAt(System.currentTimeMillis());

                    Long insert = userFavoriteRelationService.insert(relation);
                    log.info("record browsed task successfully and insert id is " + insert);
                } else {

                    UserFavoriteRelation relation = userFavoriteRelationService.getObjectById(relationIdR);
                    log.info("relation is " + relation);
                    relation.setUpdateAt(System.currentTimeMillis());
                    userFavoriteRelationService.update(relation);
                }
            }
            log.info("get task data is " + task);

            // 设置该 任务的 课程名、专题名、科目名
            Long periodId = task.getPeriodId();
            Long lessonId = task.getLessonId();
            Long subjectId = task.getSubjectId();

            Period period = periodService.getObjectById(periodId);

            Lesson lesson = lessonService.getObjectById(lessonId);
            Subject subject = subjectService.getObjectById(subjectId);

            if (null != period) {
                task.setPeriodName(period.getPeriodName());
            } else {
                model.addAttribute("code", -7001);
                return "/common/success";
            }

            if (null != lesson) {
                task.setLessonName(lesson.getLessonName());
            } else {
                model.addAttribute("code", -7002);
                return "/common/success";
            }

            if (null != subject) {
                task.setSubjectName(subject.getSubjectName());
            } else {
                model.addAttribute("code", -7003);
                return "/common/success";
            }

            List<Long> unitIds = unitService.getUnitIdsByTaskIDOrderBySort(id, 0, Integer.MAX_VALUE);
            List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(id, 0, Integer.MAX_VALUE);

            if (unitIds.size() <= 0) {
                log.info("unit is null");
            }
            if (answerIds.size() <= 0) {
                log.info("answer is null");
            }

            List<Unit> unitList = unitService.getObjectsByIds(unitIds);
            List<Answer> answerList = answerService.getObjectsByIds(answerIds);


            if (null != unitList && unitList.size() > 0) {
                for (Unit unit : unitList) {

                    if (Unit.media_type_video.equals(unit.getMediaType())) {
                        String resourceLink = unit.getResourceLink();

                        String[] urlName = resourceLink.split("\\/");
                        Map<String, String> url = VideoAndVoiceUtil.getVideoUrl(urlName[urlName.length - 1]);

                        String paths = url.get("path");
                        String signs = url.get("sign");
                        String ts = url.get("t");
                        String domain = url.get("domain");
                        String urls = domain + paths + "?sign=" + signs + "&t=" + ts;
                        unit.setResourceURL(urls);
                    }
                }
            }

            // 累计学习人数
            Integer studyCount = task.getStudyCount();
            if (DataUtils.isNullOrEmpty(studyCount)) {
                studyCount = 0;
            }
            task.setStudyCount(++studyCount);
            task.setLearningProcess(Task.learned);
            taskService.update(task);

            model.addAttribute("code", 0);
            model.addAttribute("task", task);
            model.addAttribute("unitList", unitList);
            model.addAttribute("answerList", answerList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get task error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/task/json/taskDetailJson";
    }

    /*
    * 根据课程id查找任务列表
    * */
    @RequestMapping(value = "/a/task/list/{periodId} ", method = RequestMethod.GET)
    public String getTaskListByPeriodIdJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, @PathVariable Long periodId) throws Exception {


        List<Long> taskIds = null;
        List<Task> taskList = null;

        try {
            taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(periodId, 0, Integer.MAX_VALUE);

            taskList = taskService.getObjectsByIds(taskIds);

            if (null != taskList && taskList.size() > 0) {
                log.info("get lesson list data is " + taskList.size());
            } else {
                log.info("get lesson list data is null");
            }

            //MyListUtil.get


            // periodId_alias   lessonId_alias   subjectId_alias
            List<Long> periodIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);


            model.addAttribute("code", 0);
            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period list by periodId error, lesson id is  " + periodId);
        }

        return "/academy-course-service/task/json/taskListJson";
    }


}
