package com.ptteng.academy.pc.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.SubjectService;
import com.ptteng.academy.pc.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Subject  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SubjectController {
    private static final Log log = LogFactory.getLog(SubjectController.class);

    @Autowired
    private SubjectService subjectService;
    @Autowired
    private LessonService lessonService;


    /**
     * 获得科目列表
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/subject/list", method = RequestMethod.GET)
    public String getMultiSubjectJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model)
            throws Exception {

        List<Long> ids = null;

        try {
            log.info(subjectService);
            ids = subjectService.getSubjectIdsByStatusOrderBySort(Subject.status_normal, 0, Integer.MAX_VALUE);
            if (ids == null) {
                log.info("get subject error and ids is null");
                model.addAttribute("code", 2);
                return "/common/success";
            }
            List<Subject> subjectList = subjectService.getObjectsByIds(ids);

            log.info("get  subject data is " + subjectList);
            Integer total = subjectList.size();
            model.addAttribute("code", 0);

            model.addAttribute("subjectList", subjectList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get subject error,id is  " + ids);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/subject/json/subjectListJson";
    }


    /**
     * @param
     * @Description 根据用户年级获取科目列表
     * @Author: tongzhirong
     * @Time 2017/3/9 12:33
     */
    @RequestMapping(value = "/a/subject/list/{gradeDept}", method = RequestMethod.GET)
    public String getGradeSubjectList(HttpServletRequest request, HttpServletResponse response, @PathVariable Integer gradeDept, ModelMap model)
            throws Exception {

        List<Long> ids = null;

        if (!gradeDept.equals(Subject.dept_junior_high) && !gradeDept.equals(Subject.dept_senior_high) && !gradeDept.equals(Subject.dept_study_abroad)) {

            log.info("gradeDept not legal ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            ids = subjectService.getSubjectIdsByStatusAndGradeDeptOrderBySort(Subject.status_normal, gradeDept, 0, Integer.MAX_VALUE);

            List<Subject> subjectList = subjectService.getObjectsByIds(ids);

            // subjectIdLessonsMap
            //List<Long> lessonIds = lessonService.getLessonIds(0, Integer.MAX_VALUE);
            Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, null, Lesson.status_normal);
            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);


            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);

            Map<Long, List<Lesson>> subjectIdLessonsMap = MyListUtil.convert2ListMap(Lesson.class.getDeclaredField("subjectId"), lessonList);

            model.addAttribute("code", 1000);
            model.addAttribute("message", "success");
            model.addAttribute("subjectList", subjectList);
            model.addAttribute("subjectIdLessonsMap", subjectIdLessonsMap);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user grade subject error,id is  " + ids);
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/subject/json/subjectListJson";
    }

}

