package com.ptteng.academy.pc.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.http.cookie.MD5Util;
import com.ptteng.academy.common.model.Sms;
import com.ptteng.academy.common.service.SmsService;
import com.ptteng.academy.pc.util.UserNameUtil;
import com.ptteng.academy.pc.util.mailUtil;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.storage.util.CaptchaUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * User  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class RegisterController {

    private static final Log registerLog = LogFactory.getLog("register");

    private static final Log userLog = LogFactory.getLog("user");

    @Autowired
    private UserService userService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    private boolean isCaptcha = false;

    // 1、验证码发送
    @RequestMapping(value = "/a/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type, String areaCode) throws ServiceException, ServiceDaoException {
        registerLog.info(mobile + " want send sms of type " + type);


        if (StringUtils.isBlank(areaCode)) {
            areaCode = "+86";
        }

        if (StringUtils.isBlank(mobile)) {
            registerLog.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }

        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        String realMobile = areaCode + mobile;
        registerLog.info("final mobile is : " + realMobile);

        registerLog.info("=====================" + type);
        if ("register".equals(type)) {
            Long uid = userService.getUserIdByMobile(mobile);
            if (uid != null) {
                registerLog.info(type + " is already exist  " + mobile);

                model.addAttribute("code", -2007);
                return "/common/success";
            }

        } else {
            Long uid = userService.getUserIdByMobile(mobile);
            if (uid == null) {

                registerLog.info(type + " is not already exist  " + mobile);

                model.addAttribute("code", -2000);
                return "/common/success";
            }
        }

        int code = 0;

        try {
            String result = this.smsService.sendMsg(realMobile, type);
//            smsService.getSmsIdByMobileAndType(mobile,type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error(mobile + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }


    // 2、邮箱验证码发送
    @RequestMapping(value = "/a/mail/code/send", method = RequestMethod.POST)
    public String sendMailVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mail,
                                 String type) throws ServiceException, ServiceDaoException {
        registerLog.info(mail + " want send mail sms of type " + type);

        try {

            if (StringUtils.isBlank(mail)) {
                registerLog.info(mail + " want send sms of type " + type + " null mail ");
                model.addAttribute("code", -2022);
                return "/common/success";
            } else {
                //邮箱格式校验
                registerLog.info("mail address verify ");
                Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
                Matcher m = p.matcher(mail);
                boolean result = m.matches();
                registerLog.info("mail address verify result : " + result);
                if (result) {
                    registerLog.info("mail address verify OK");
                } else {
                    registerLog.info("mail address verify fail");
                    model.addAttribute("code", -2023);
                    return "/common/success";
                }
            }

            if (StringUtils.isBlank(type)) {
                type = "password";
            }

            registerLog.info("=====================" + type);
            if ("register".equals(type) || "bind".equals(type)) {
                Long uid = this.userService.getUserIdByMail(mail);
                if (uid != null) {
                    registerLog.info(type + " is already exist  " + mail);
                    model.addAttribute("code", -2019);
                    return "/common/success";
                }
            } else {
                Long uid = this.userService.getUserIdByMail(mail);
                if (uid == null) {
                    registerLog.info(type + " is not already exist  " + mail);
                    model.addAttribute("code", -2000);
                    return "/common/success";
                }
            }

            int code = 0;

            String result = "";
            sendMailMsg(mail, type);

            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);

        } catch (Exception t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error(mail + " send message error of type " + type);
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }

    // 语音验证码
    @RequestMapping(value = "/a/code/voice", method = RequestMethod.POST)
    public String sendVoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            String mobile, String type, String areaCode) throws ServiceException, ServiceDaoException {
        userLog.info(mobile + " want send voice of type " + type);

        if (StringUtils.isBlank(areaCode)) {
            areaCode = "+86";
        }

        if (StringUtils.isBlank(mobile)) {
            userLog.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }
        if (StringUtils.isBlank(type)) {
            type = "password";
        }

        if ("register".equals(type)) {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid != null) {
                userLog.info(type + " is already exist  " + mobile);
                model.addAttribute("code", -2007);
                return "/common/success";
            }
        } else {
            Long uid = this.userService.getUserIdByMobile(mobile);
            if (uid == null) {
                userLog.info(type + " is not already exist  " + mobile);
                model.addAttribute("code", -2000);
                return "/common/success";
            }
        }

        String realMobile = mobile;
        userLog.info("final mobile is : " + realMobile);

        int code = 0;

        try {
            String result = this.smsService.sendVoice(realMobile, type);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = -2003;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = -2008;
                    break;
                case SmsService.ErrorCode_sendError:
                    code = -2015;
                    break;
                default:

            }

            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            userLog.error(t.getMessage());
            userLog.error(mobile + " send voice error of type " + type);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    // 正常注册
    @RequestMapping(value = "/a/register", method = RequestMethod.POST)
    public String normalAddUserJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String account,
                                    String verify, String openid, String pwd, String areaCode) {


        String verify_type = "register";
        Long uid = null;
        userLog.info("areaCode=========" + areaCode);
        String img = "http://learn-10047330.file.myqcloud.com/article/e555c361-cb58-48c1-854f-9c79003b763c.png";

        // 账号密码入参、判空
        if (DataUtils.isNullOrEmpty(account) || StringUtil.isEmpty(pwd) || StringUtil.isEmpty(verify)) {

            registerLog.info("参数空");
            model.addAttribute("code", -2020);
            return "/common/success";
        }

        registerLog.info("params verify OK");


        boolean verifyResult = false;
        try {

            registerLog.info("==========1、校验验证码==========");
            if (verifyModel()) {
                registerLog.info("is test model ");
                if ("555555".equals(verify)) {
                    registerLog.info("test ,so not verify account ");
                    verifyResult = true;
                } else {
                    if (DataUtils.isNullOrEmpty(areaCode)){
                    registerLog.info("log1: areaCode====="+areaCode+"||account is "  + account + ",type = " + verify_type + ",verify" + verify);
                    verifyResult = verifyMobileCode( account, verify_type, verify);
                    }else {
                        registerLog.info("log2: account is " + areaCode + account + ",type = " + verify_type + ",verify" + verify);
                        verifyResult = verifyMobileCode("+86" + account, verify_type, verify);
                    }
                }
            } else {
                registerLog.info("log3: account is " + areaCode + account + ",type = " + verify_type + ",verify" + verify);
                verifyResult = verifyMobileCode("+86" + account, verify_type, verify);
            }
            if (verifyResult) {
                registerLog.info("right verify code");

            } else {
                registerLog.error("wrong verify code");
                model.addAttribute("code", -2005);

                return "/common/success";
            }

            registerLog.info("==========2、校验account类型==========");
            String accountType = "";
            // 判断格式为手机或者邮箱
            Pattern p = Pattern.compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
            Matcher m = p.matcher(account);
            boolean result = m.matches();
            registerLog.info("mail address verify result : " + result);
            if (result) {
                accountType = "mail";

            } else {
                accountType = "mobile";
            }

            Long userId = null;
            String code = null;

            // 数据库查询是否存在
            if ("mail".equals(accountType)) {
                userId = userService.getUserIdByMail(account);
                code = "2026";
            } else if ("mobile".equals(accountType)) {
                userId = userService.getUserIdByMobile(account);
                code = "2025";
            }
            //如果是mail,mobile在数据库中有对应的uid,则进一步判断是否有密码.
            if (DataUtils.isNotNullOrEmpty(userId)) {
                User user = userService.getObjectById(userId);
                String userPwd = user.getPwd();
                if (DataUtils.isNotNullOrEmpty(userPwd)) {

                    // 不让注册
                    model.addAttribute("code", code);
                    return "/common/success";
                } else {

                    // 数据库查询是否有密码
                    // 无密码则密码入库注册成功
                    String pass = PasswordUtils.encode(pwd);
                    user.setPwd(pass);
                    userService.update(user);
                    //如果入参带有openid(这时候其实是用微信登录跳转过来的情况,已带有手机号或者邮箱参数
                    if (DataUtils.isNotNullOrEmpty(openid)) {
                        UserOpenidRelation relation = new UserOpenidRelation();
                        relation.setType("web");
                        relation.setUid(userId);
                        relation.setOpenid(openid);
                        Long insert = userOpenidRelationService.insert(relation);
                        registerLog.info("微信openid插入表中");
                    }
                }

            } else {

                User user = new User();
                if ("mobile".equals(accountType)) {
                    user.setMobile(account);
                } else if ("mail".equals(accountType)) {
                    user.setMail(account);
                }
                String pass = PasswordUtils.encode(pwd);
                user.setPwd(pass);
                Long now = System.currentTimeMillis();
                user.setLastLoginAt(now);
                user.setRegisterAt(now);
                user.setImg(img);
                user.setStatus(User.STATUS_NORMAL);
                UserNameUtil userNameUtill = new UserNameUtil();
                user.setAlias(userNameUtill.getRandomName());

                //is_read公告状态 is_member 会员状态
                user.setPoststatus(User.POST_READ);
                user.setIsMember(User.IS_NOT_MEMBER);
                user.setIsRead(User.NOTICE_UNREAD);

                registerLog.info("insert user : " + user);
                uid = userService.insert(user);
                if (DataUtils.isNotNullOrEmpty(openid)) {

                    UserOpenidRelation relation = new UserOpenidRelation();
                    relation.setType("web");
                    relation.setUid(uid);
                    relation.setOpenid(openid);
                    Long insert = userOpenidRelationService.insert(relation);

                }
            }

            String token = IdentityUtil.encodeCookie("phone", uid);
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            cookieUtil.setIdentity(request, response, maps, uid);

            model.addAttribute("code", 0);
            model.addAttribute("token", token);
            model.addAttribute("uid", uid);


        } catch (Throwable t) {
            t.printStackTrace();
            registerLog.error(t.getMessage());
            registerLog.error(" get user error ");
            model.addAttribute("code", -1);
        }


        // 放行
        return "/academy-course-service/user/json/userRegister";
    }


    //4、查询是否注册
    @RequestMapping(value = "/a/verify/openid", method = RequestMethod.GET)
    public String verifyMobile(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type, String verify) {
        registerLog.info(" verify mobile if register ==========");

        Boolean result = false;
        Long uid = null;
        boolean verifyResult = false;

        String verify_type = "bind";
        try {
            if (StringUtils.isEmpty(openid)) {
                registerLog.info(" openId is null");
                model.addAttribute("code", -3002);
                return "/common/success";
            }

//             如果验证码存在则校验验证码
            if (!DataUtils.isNullOrEmpty(verify)) {
                if ("555555".equals(verify)) {
                    registerLog.info("test ,so not verify account ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyCode(openid, verify_type, verify);
                }

                if (verifyResult) {
                    registerLog.info("right verify code");
                } else {
                    registerLog.error("wrong verify code");
                    model.addAttribute("code", -2005);
                    return "/common/success";
                }

            }

            if ("mobile".equals(type)) {
                uid = userService.getUserIdByMobile(openid);

            } else {
                uid = userService.getUserIdByMail(openid);

            }

            User user = userService.getObjectById(uid);
            //查询是否注册
            if (user == null) {
                registerLog.info("openid unregistered ,openid is "+openid+" type is "+type );
            }else {
                //密码为空为未注册
                String pwd = user.getPwd();
                if (null != pwd) {
                    result = true;
                }
            }




            model.addAttribute("code", 0);
            model.addAttribute("register", result);


        } catch (Throwable t) {
            registerLog.error("verify openid : " + openid + " error  ");
            t.printStackTrace();

        }
        return "/common/boolResult";
    }

    // 生成图形验证码
    @RequestMapping(value = "/a/captcha/generate", method = RequestMethod.GET)
    public void captchaGenerate(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        registerLog.info("To captchaGenerate ------------------");
        try {
            // 设置页面不缓存
            response.reset();
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0);
            response.setContentType("image/gif");

            // 生成随机字符
            String randomStr = RandomStringUtils.randomAlphabetic(4).toUpperCase();
            registerLog.info("randomStr: " + randomStr);
            // 存入cookie
            response.addCookie(new Cookie("captcha", MD5Util.getMd5Sum(randomStr)));

            // 生成图片流
            BufferedImage bi = new CaptchaUtil().generate(165, 40, randomStr).getImage();
            // 创建输出流
            OutputStream out = response.getOutputStream();
            // 将图片写入到输出流中去
            ImageIO.write(bi, "JPG", out);
            // 强制刷新
            out.flush();
            // 关闭输出流
            out.close();
        } catch (Exception e) {
            registerLog.error("get captchaGenerate error", e);
            model.addAttribute("code", -1);
        }

    }

    // 验证图形验证码
    @RequestMapping(value = "/a/captcha/verify", method = RequestMethod.GET)
    public String captchaVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                String inputValue) throws Exception {
        registerLog.info("To captchaVerify ------------------");

        registerLog.info("inputValue: " + inputValue);

        try {
            String cookieValue = "";
            try {
                cookieValue = RequestUtil.getCookie(request, "captcha").getValue();
            } catch (Exception e) {
                registerLog.error("got error when getCookie");
            }
            registerLog.info("cookieValue: " + cookieValue);

            if (StringUtils.isBlank(inputValue) || StringUtils.isBlank(cookieValue)) {
                model.addAttribute("code", -2005);
                return "/common/success";
            }

            String md5Value = "";
            try {
                md5Value = MD5Util.getMd5Sum(inputValue.toUpperCase());
            } catch (NoSuchAlgorithmException e) {
                registerLog.error("got error when getMD5");
            }

            registerLog.info("md5Value: " + md5Value);

            if (md5Value.equals(cookieValue)) {
                isCaptcha = true;
                model.addAttribute("code", 0);
            } else {
                isCaptcha = false;
                model.addAttribute("code", -2005);
            }
        } catch (Exception e) {
            registerLog.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //6、绑定手机/邮箱/三方账号
    @RequestMapping(value = "/a/u/bind", method = RequestMethod.PUT)
    public String bind(HttpServletRequest request, HttpServletResponse response, ModelMap model, String openid, String type, String verify) throws Exception {

        String userId = cookieUtil.getKeyIdentity(request, "userId");
        Long uid = Long.valueOf(userId);
        registerLog.info("get uid " + uid);

        User user = userService.getObjectById(uid);
        String verify_type = "bind";

        registerLog.info("user " + uid + " bound openid " + openid + " type " + type);

        Boolean result = false;
        try {
            registerLog.info("==========1、校验参数是否为空==========");
            if (StringUtil.isEmpty(openid)) {
                model.addAttribute("code", -2012);
                return "/common/success";
            } else if ((UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) && StringUtil.isEmpty(verify)) {
                registerLog.info("verify is null");
                model.addAttribute("code", -2021);
                return "/common/success";
            } else {
                registerLog.info("params verify OK");
            }

            boolean verifyResult = false;
            registerLog.info("==========2、校验验证码==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {

                registerLog.info("is test model ");
                if ("555555".equals(verify)) {
                    registerLog.info("test ,so not verify account ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyCode(openid, verify_type, verify);
                }

                if (verifyResult) {
                    registerLog.info("right verify code");
                } else {
                    registerLog.error("wrong verify code");
                    model.addAttribute("code", -2005);
                    return "/common/success";
                }

            } else {
                registerLog.info("not mail or mobile register , no verify ");
            }

            //openid是否绑定过
            Long relationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndType(openid, type);
            if (null != relationId) {
                registerLog.info("openid " + openid + " relation : " + relationId + " exist");
                if (UserOpenidRelation.TYPE_MAIL.equals(type)) {
                    model.addAttribute("code", -2026);
                } else if (UserOpenidRelation.TYPE_MOBILE.equals(type)) {
                    model.addAttribute("code", -2025);
                } else {
                    model.addAttribute("code", -2007);
                }
                return "/common/success";
            } else {
                registerLog.info("openid " + openid + " type " + type + " not exist and can bind ");
            }

            //用户是否存在该类型openid
            Long userRelationId = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(uid, type);

            UserOpenidRelation relation = userOpenidRelationService.getObjectById(userRelationId);
            if (null != userRelationId) {
                registerLog.info(" user type : " + type + " relation id : " + userRelationId + " exist");
                if (UserOpenidRelation.TYPE_MAIL.equals(type) || UserOpenidRelation.TYPE_MOBILE.equals(type)) {
                    relation.setOpenid(openid);
                    model.addAttribute("code", -2028);
                    userOpenidRelationService.update(relation);

                } else {
                    model.addAttribute("code", -2024);
                }
            } else {
                registerLog.info("user " + uid + " type " + type + " openid not exist and can bind ");
                UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                userOpenidRelation.setUid(uid);
                userOpenidRelation.setOpenid(openid);
                userOpenidRelation.setType(type);
                Long userOpenId = userOpenidRelationService.insert(userOpenidRelation);
                registerLog.info("insert userOpenRelation : " + userOpenId + " success");
            }

            registerLog.info("==========3、更新用户手机邮箱信息==========");
            if (UserOpenidRelation.TYPE_MOBILE.equals(type)) {
                user.setMobile(openid);
                registerLog.info("update user mobile");
            } else if (UserOpenidRelation.TYPE_MAIL.equals(type)) {
                user.setMail(openid);
                registerLog.info("update user mail");
            } else {
                registerLog.info("not mail or mobile register , no user info update ");
            }


//            registerLog.info("==========4、添加逆袭豆==========");
//            if (UserOpenidRelation.TYPE_MOBILE.equals(type) || UserOpenidRelation.TYPE_MAIL.equals(type)) {
//
//                Long score = user.getScore();
//                user.setScore(score + 20);
//                registerLog.info("user score : " + score + " >>>>>>>>>> " + user.getScore());
//
//            } else {
//                registerLog.info("not mail or mobile register , no score add ");
//            }
//            registerLog.info("update user : " + user);
            userService.update(user);

            model.addAttribute("code", 0);
            model.addAttribute("register", result);

        } catch (Exception t) {
            registerLog.error("user bind error  ");
            t.printStackTrace();

        }
        return "/common/boolResult";
    }

    /*
     7.用户退出登录
       */
    @RequestMapping(value = "/a/u/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model) {
        userLog.info(" welcome to manager logout ");

        try {
            cookieUtil.clearCookie(response);

            model.addAttribute("code", 0);

            return "/common/success";
        } catch (Throwable t) {
            userLog.error("user logout error  ");
            t.printStackTrace();

            return "/common/success";

        }
    }

//验证openid是否绑定手机
    @RequestMapping(value = "/a/verify/check", method = RequestMethod.GET)
    public String checkOpenid(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model , String account ,String os ,String type) {
        userLog.info(" account:" + account + "os:" + os);
        if(StringUtil.isEmpty(account) || StringUtil.isEmpty(os)){
            model.addAttribute("code",-1000);
            return "/common/success";
        }
        Boolean flag = false;
        if(type.equals("mobile")){
            flag = false;
        } else if(type.equals("mail")){
            flag =true;
        }else {
            model.addAttribute("code", -1002);
        }
        Long uid = null;
        try {
            if(flag){
                uid = userService.getUserIdByMail(account);
            }else {
                uid = userService.getUserIdByMobile(account);

            }

            if(uid != null){
                Long relationId = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(uid,os);
                if(relationId != null){
                    userLog.info("用户已绑定该类型");
                    model.addAttribute("code", -2024);
                }else {
                    userLog.info("可以绑定");
                    model.addAttribute("code", 0);
                }
            }else {
                userLog.info("无此用户");
                model.addAttribute("code", -2000);
            }


            return "/common/success";
        } catch (Throwable t) {
            userLog.error("check opein with account erro");
            t.printStackTrace();

            model.addAttribute("code",2);

            return "/common/success";

        }

    }

    public String sendMailMsg(String mail, String type) throws ServiceException, ServiceDaoException {

        String code = "";
        String template = "";
        int count = 0;
        Sms sms = new Sms();

        if (type.equals("register")) {
            template = "academyRegisterMail";
        } else if (type.equals("password")) {
            template = "academyPwdMail";
        } else if (type.equals("bind")) {
            template = "academyBindMail";
        }
        registerLog.info("template is :" + template);

        Long smsId = smsService.getSmsIdByMobileAndType(mail, type);
        registerLog.info(" smsId = " + smsId);
        String returnString = "";
        // 已经请求过验证码
        if (smsId != null) {
            registerLog.info(" didn't send sms ever ");
            // 检验每天发送次数
            sms = smsService.getObjectById(smsId);
            Format formatter = new SimpleDateFormat("d");
            String ftime = formatter.format(System.currentTimeMillis());
            String stime = formatter.format(sms.getSendAt());
            if (!ftime.equals(stime)) {
                sms.setCount(0);
            }
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;
            if (sms.getCount() < 5) {
                registerLog.info(" < 5   ");

                // 同类型30分钟内验证码相同
                Long delay = System.currentTimeMillis() - sms.getTypeSendAt();
                if (delay <= 1800000) {

                    registerLog.info("30分钟内发送相同验证码");
                    code = sms.getMessage();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        registerLog.error(e.getMessage());
                    }

                    registerLog.info("邮件发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档
                        sms.setSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        registerLog.info("信息发送成功");
                    }

                } else {
                    registerLog.info("30分钟外发送相同验证码");
                    // 生成验证码
                    Random rand = new Random();
                    for (int i = 0; i < 6; i++) {
                        code = code + rand.nextInt(10);
                    }
                    code = code.trim();

                    try {
                        returnString = mailUtil.sendSMSMail(mail, code, template);
                    } catch (Exception e) {
                        registerLog.error(e.getMessage());
                    }

                    registerLog.info("短信发送返回值：" + returnString);

                    if (returnString.equals("-1")) {
                        return SmsService.ErrorCode_sendError;
                    } else if (returnString.equals("0")) {
                        // TODO 处理返回值,参见HTTP协议文档;
                        sms.setSendAt(System.currentTimeMillis());
                        sms.setTypeSendAt(System.currentTimeMillis());
                        count = sms.getCount();
                        count += 1;
                        sms.setCount(count);
                        sms.setMessage(code);
                        registerLog.info("超过30分钟发送新验证码");
                    }

                }
                smsService.update(sms);
            } else {
                registerLog.info("count > 5 ");

                return smsService.ErrorCode_SMS_smsMoreThan5;
            }

            // 第一次发送请求
        } else {

            registerLog.info(" first send code   ");
            // 生成验证码

            Random rand = new Random();
            for (int i = 0; i < 6; i++) {
                code = code + rand.nextInt(10);
            }
            code = code.trim();
            sms.setCount(0);
            int intNum = sms.getCount() + 1;
            String num = "" + intNum;

            // 发送邮件
            try {

                returnString = mailUtil.sendSMSMail(mail, code, template);

                registerLog.info("短信发送返回值：" + returnString);
                if (returnString.equals("-1")) {
                    return SmsService.ErrorCode_sendError;
                } else if (returnString.equals("0")) {
                    // TODO 处理返回值,参见HTTP协议文档
                    count += 1;
                    // 保存sms对象信息
                    sms.setMobile(mail);
                    sms.setType(type);
                    sms.setMessage(code);
                    sms.setSendAt(System.currentTimeMillis());
                    sms.setTypeSendAt(System.currentTimeMillis());
                    sms.setCount(count);
                    Long ms = smsService.insert(sms);
                    registerLog.info("发送成功！ 信息保存结果：" + ms);
                }

            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }

        }

        return "";
    }


    private boolean verifyModel() {
//        return "test".equals(this.accountConfig.get("testModel"));
        return true;
    }

    // 验证码校验
    private boolean verifyCode(String openid, String type, String verify) throws Exception {

        Boolean verifyResult = false;

        if (verifyModel()) {
            registerLog.info("is test model ");
            if ("555555".equals(verify)) {
                registerLog.info("test ,so not verify account ");
                verifyResult = true;
            } else {
                registerLog.info("log1: account is " + openid + ",type = " + type + ",verify" + verify);
                verifyResult = verifyMobileCode(openid, type, verify);
            }
        } else {
            registerLog.info("log1: account is " + openid + ",type = " + type + ",verify" + verify);
            verifyResult = verifyMobileCode(openid, type, verify);
        }
        return verifyResult;
    }

    private boolean verifyMobileCode(String mobile, String type, String verify)
            throws ServiceException, ServiceDaoException {

        registerLog.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        registerLog.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        registerLog.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        registerLog.info("message is " + message);

        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            registerLog.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

}