package com.ptteng.academy.pc.controller;

import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.SubjectService;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Controller
public class PeriodController {

    private static final Log periodLog = LogFactory.getLog("Period");

    @Autowired
    private PeriodService periodService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;
    @Autowired
    private CookieUtil cookieUtil;

    //前一个课程
    @RequestMapping(value = "/a/previous/period/{id}", method = RequestMethod.GET)
    public String periodPreviousDetailJson(HttpServletRequest request, HttpServletResponse response, @PathVariable Long id, ModelMap model) {

        Period period = null;
        Boolean previousPeriodStatus = false;

        try {
            period = periodService.getObjectById(id);

            if (null == period) {
                model.addAttribute("code", -5043);
                return "/common/success";
            }
            // 判断是否为第一个课程
            Integer periodSort = period.getSort();

            periodLog.info("task sort is : " + periodSort);
            if (periodSort <= 1) {
                periodLog.info("the period is first sort ");
                model.addAttribute("code", -4005);
                return "/common/success";
            }

            Long lessonId = period.getLessonId();
            Long previousPeriodId = periodService.getPeriodIdByLessonIDAndSort(lessonId, periodSort - 1);
            Period previousPeriod = periodService.getObjectById(previousPeriodId);
            previousPeriodStatus = true;

            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
            model.addAttribute("period", previousPeriod);
            model.addAttribute("previousPeriodStatus", previousPeriodStatus);

        } catch (Throwable t) {
            periodLog.error(t.getMessage());
            periodLog.error("get user grade subject error,id is  ");
            model.addAttribute("code", -1);
        }
        return "/academy-course-service/period/json/periodDetailJson";
    }

    //后一个课程
    @RequestMapping(value = "/a/next/period/{id}", method = RequestMethod.GET)
    public String periodNextDetailJson(HttpServletRequest request, HttpServletResponse response, @PathVariable Long id, ModelMap model) {

        Period period = null;
        Period previousPeriod = null;
        Boolean nextPeriodStatus = false;

        try {
            period = periodService.getObjectById(id);

            if (null == period) {
                model.addAttribute("code", -5043);
                return "/common/success";
            }
            // 判断是否为 本专题最后一个课程
            Integer periodSort = period.getSort();
            Long lessonId = period.getLessonId();
            List<Long> periodIds = periodService.getPeriodIdsByLessonIDOrderBySort(lessonId, 0, Integer.MAX_VALUE);

            Long maxSortId = periodIds.get(periodIds.size() - 1);

            Period maxSortPeriod = periodService.getObjectById(maxSortId);
            Integer maxSort = maxSortPeriod.getSort();

            periodLog.info("task sort is : " + periodSort);

            if (periodSort > maxSort) {
                periodLog.info("the periodSort value erro  ");
                model.addAttribute("code", -4005);
                nextPeriodStatus = false;
                return "/common/success";
            } else if (periodSort.equals(periodIds.size())) {

                nextPeriodStatus = false;
                periodLog.info("最后一个课时：" + period);
            } else {
                Long previousPeriodId = periodService.getPeriodIdByLessonIDAndSort(lessonId, periodSort + 1);
                previousPeriod = periodService.getObjectById(previousPeriodId);
                nextPeriodStatus = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
            model.addAttribute("period", previousPeriod);
            model.addAttribute("nextPeriodStatus", nextPeriodStatus);

        } catch (Throwable t) {
            periodLog.error(t.getMessage());
            periodLog.error("get user grade subject error,id is  ");
            model.addAttribute("code", -1);
        }
        return "/academy-course-service/period/json/periodDetailJson";
    }

    /**
     * 查看课程详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/period/{id}", method = RequestMethod.GET)
    public String getPeriodJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        periodLog.info("get data : id= " + id);
        try {
            Period period = periodService.getObjectById(id);
            if (period == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Long subjectId = period.getSubjectId();
            Long lessonId = period.getLessonId();
            Subject subject = subjectService.getObjectById(subjectId);
            Lesson lesson = lessonService.getObjectById(lessonId);
            if (subject != null) {
                period.setSubjectName(subject.getSubjectName());
            }
            if (lesson != null) {
                period.setLessonName(lesson.getLessonName());
            }

            periodLog.info("get period data is " + period);


            model.addAttribute("code", 0);
            model.addAttribute("period", period);

        } catch (Throwable t) {
            t.printStackTrace();
            periodLog.error(t.getMessage());
            periodLog.error("get lesson error,id is  " + id);
            model.addAttribute("code", -100000);
        }


        return "/academy-course-service/period/json/periodDetailJson";
    }
}
