package com.ptteng.academy.pc.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.model.Article;
import com.ptteng.academy.admin.service.ArticleService;
import com.ptteng.academy.admin.service.ManagerService;
import com.ptteng.academy.pc.util.DynamicUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.model.Task;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.SubjectService;
import com.ptteng.academy.course.service.TaskService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog(ArticleController.class);

    private final String Img_Module_Common = "common";
    @Autowired
    private ArticleService articleService;


    /**
     * 单个查询展示内容
     *
     * @param request
     * @param response
     * @param model
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("get data : id= " + aid);
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                if (article == null) {
                    model.addAttribute("code", 2);
                    return "/common/success";
                } else {
                    log.info("get article data is " + article);
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/article/json/articleDetailJson";
    }


    /**
     * 条件查询内容
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param startAt
     * @param endAt
     * @param type
     * @param createBy
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/article/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Long startAt, Long endAt, Integer type, String title, String createBy, String status)
            throws Exception {
        log.info("/web/a/article/list ,page is:" + page + ",size is" + size + ",startAt is" + startAt + ",endAt is" + endAt + ", type is " +
                "" + type + " , source is " + " createBy is " +
                createBy + " status is " + status);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        try {

//			if(startAt == null && endAt == null && type == null && createBy == null && status == null){
//				ids = articleService.getArticleIds(start, size);
//				total=articleService.countArticleIds();
//				log.info("===============================================1"+ids + "=====" + total);
//			} else {
            Map<String, Object> param = DynamicUtil.getArticleListParam(startAt, endAt, type, createBy, title, Article.Status_Published);
            log.info("        param is    " + param);
//				Map<String, Object> countparam = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, true);
            log.info("pageList : page= " + start + " , size=" + size);
            ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
            count = articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("===============================================2" + ids + "=====" + total);
//			}

            if (ids != null && ids.size() > 0) {

                log.info("get article list ids is" + ids);
                List<Article> articleList = articleService.getObjectsByIds(ids);
                model.addAttribute("articleList", articleList);
            } else {
                model.addAttribute("code", 2);
                return "/common/success";
            }
            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {

                next = true;
            }
            model.addAttribute("next", next);
            log.info("next is : " + next);

            Integer totalPage = 1;
            if (total > 0) {

                totalPage = (total - 1) / size + 1;
                log.info("totalPage is : " + totalPage);
            }

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get articleList error,qfrom is" + startAt + ",qto is" + endAt + ", type is " +
                    "" + type + " , source is " + " createBy is " +
                    createBy + " status is " + status);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/article/json/articleMultiJson";
    }

    /**
     * 根据type查找已发布内容
     *
     * @param page
     * @param size
     * @param type
     * @return
     * @throws Exception
     */
    public List<Article> getArticleListByType(Integer page, Integer size, Integer type) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        List<Long> ids = articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, size);
        log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids);


        List<Article> articleList = articleService.getObjectsByIds(ids);
        log.info("get article data is " + articleList);


        return articleList;
    }
}

