package com.qding.framework.pay.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.qding.common.pay.model.IndentInfo;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.common.pay.service.PayOrderService;
import com.qding.community.util.WXMessageUtil;
import com.qding.community.util.XingyeResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@Controller
public class PayController {

    private static final Log log = LogFactory.getLog(PayController.class);

    @Autowired
    private PayOrderService payOrderService;

    @Autowired
    private IndentInfoService indentInfoService;


    public static final String PAY_YL = "payOrder";
    public static final String PAY_LL = "yintongPay";
    public static final String PAY_ALI = "aliPay";
    public static final String PAY_YINl = "ylPay";
    public static final String PAY_TONGL = "tlpay";
    public static final String PAY_XINGYE = "xyPay";//兴业微信
    public static final String PAY_CAIFUTONG = "cftPay";//兴业网关支付
    public static final String PAY_Cftkj = "cftKjPay";//兴业快捷支付
    public static final String PAY_DAIFU = "daifu";//兴业财付通--提现


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/p/pay", method = RequestMethod.GET)
    public String getPay(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, Long gorderID)
            throws Exception {

        log.info("/p/u/pay  to /pay/view/payList");
        String dd = payOrderService.payTest("code _", PAY_ALI);
        log.info("  code " + dd);
        //	Gorder gorder = gorderService.getObjectById(gorderID);

        //	model.addAttribute("gorder", gorder);

        return "/pay/view/payList";
    }

    /**
     * 通过订单号获取订单相关信息，返回支付选择页
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/indent/{indentCode}", method = RequestMethod.GET)
    public String getPay(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, @PathVariable String indentCode)
            throws Exception {

        log.info("/p/u/pay  to /pay/view/payList");
        String kk = indentInfoService.getIndentByIndentCode(indentCode);
        //获取金额

        //获取地址

        //收货人信息

        //商品名称

        //返回到支付选择页面

        return "/pay/view/payList";
    }

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    /*@RequestMapping(value = "/p/u/pay2", method = RequestMethod.GET)
    public String pay(HttpServletRequest request, HttpServletResponse response,
                      ModelMap model, Long gorderID) throws Exception {

        log.info("/p/u/pay  to redirect:pay gorderID:" + gorderID);

        Gorder gorder = null;
        try {
            gorder = gorderService.getObjectById(gorderID);
            BigDecimal bd = new BigDecimal(gorder.getTotal());
            BigDecimal bd2 = new BigDecimal(100);
            BigInteger re = bd.multiply(bd2).toBigInteger();

            WXMessageUtil.setDomainUrl(request);
            String payFront = WXMessageUtil.domain + "/pay/front";
            String payBack = WXMessageUtil.domain + "/pay/back/" + code;

            User user = (User) request.getAttribute(CookieConstant.Cookie_User);

            String page = payOrderService.pay(user.getId() + "", gorder.getCode(),
                    MyTimeUtil.convertLong2String(gorder.getGorderAt(),
                            "yyyyMMddHHmmss"), gorder.getCode(), re.toString(), "", payFront,
                    payBack, PAY_YL);

            log.info("pay url :" + page);
            response.setContentType("text/html; charset=utf-8");

            // 修改状态为付款中
//			gorder.setStatus(Gorder.Status_Paying);
//			gorder.setPayAt(System.currentTimeMillis());
//			gorderService.update(gorder);

            return "redirect:" + page;

        } catch (Exception e) {
            log.error("get gorder error:" + e.getMessage());

            return "";
        }

    }

    @RequestMapping(value = "/p/u/llPay", method = RequestMethod.GET)
    public String yintongPay(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, Long gorderID, String code, Long userId)
            throws Exception {

        log.info("/p/u/llPay gorderID:" + gorderID);

        Gorder gorder = null;
        try {


            gorder = gorderService.getObjectById(gorderID);

            WXMessageUtil.setDomainUrl(request);
            String payFront = WXMessageUtil.domain + "/pay/front/" + code;
            String payBack = WXMessageUtil.domain + "/pay/llBack/" + gorder.getCode();

            User user = (User) request.getAttribute(CookieConstant.Cookie_User);

            String req_data = payOrderService.pay(userId + "", gorder.getCode(),
                    MyTimeUtil.convertLong2String(gorder.getGorderAt(),
                            "yyyyMMddHHmmss"), gorder.getCode(), gorder.getTotal(), "", payFront,
                    payBack, PAY_LL);

            request.setAttribute("req_data", req_data);
            log.info("req_data :" + req_data);

            request.setAttribute("req_url", payOrderService.getParam("SERVER_URL", PAY_LL));
            log.info("req_url :" + payOrderService.getParam("SERVER_URL", PAY_LL));

            response.setContentType("text/html; charset=utf-8");

            // 修改状态为付款中
            *//*gorder.setStatus(Gorder.Status_Paying);
            gorder.setType(Gorder.Type_ll_pay);
            gorder.setPayAt(System.currentTimeMillis());
            gorderService.update(gorder);*//*

            //return "redirect:" + page;
            return "/pay/view/paySure";

        } catch (Exception e) {
            log.error("get gorder error:" + e.getMessage());

            return "";
        }

    }

    @RequestMapping(value = "/p/u/aliPay", method = RequestMethod.GET)
    public String aliPay(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model, Long gorderID)
            throws Exception {

        log.info("/p/u/aliPay gorderID:" + gorderID);

        Gorder gorder = null;
        try {
            gorder = gorderService.getObjectById(gorderID);

            WXMessageUtil.setDomainUrl(request);
            String payFront = WXMessageUtil.domain + "/pay/front/" + gorder.getCode();
            String payBack = WXMessageUtil.domain + "/pay/aliBack/" + gorder.getCode();

            User user = (User) request.getAttribute(CookieConstant.Cookie_User);

            String outHtml = payOrderService.pay(user.getId() + "", gorder.getCode(),
                    MyTimeUtil.convertLong2String(gorder.getGorderAt(),
                            "yyyyMMddHHmmss"), gorder.getCode(), gorder.getTotal(), "", payFront,
                    payBack, PAY_ALI);

            request.setAttribute("outHtml", outHtml);
            log.info("outHtml :" + outHtml);

            response.setContentType("text/html; charset=utf-8");

            // 修改状态为付款中
            gorder.setStatus(Gorder.Status_Paying);
            gorder.setType(Gorder.Type_ali_pay);
            gorder.setPayAt(System.currentTimeMillis());
            gorderService.update(gorder);

            return "/pay/view/aliPaySure";

        } catch (Exception e) {
            log.error("get gorder error:" + e.getMessage());

            return "";
        }

    }*/

    /*
    *
    *
    * */
    @RequestMapping(value = "/pay/{type}", method = RequestMethod.GET)
    public String Pay(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable String type,
                      String indentCode, String payFrontUrl) throws Exception {
        log.info("/a/pay/" + type + "     indentCode : " + indentCode + " payFrontUrl = " + payFrontUrl);
        log.info("i am in =======================================================================");

          String indentInfoJsonStr = indentInfoService.getIndentByIndentCode(indentCode);


        log.info("indentInfoJsonStr------"+indentInfoJsonStr);

        if (indentInfoJsonStr.equals("100")) {
            model.addAttribute("code", 100);
            model.addAttribute("message", "订单超时");
            return "/data/json";
        }

        IndentInfo indentInfo =
                GsonUtil.fromJson(indentInfoJsonStr, IndentInfo.class);
        indentInfo.setTotalMoney(0.01);

        // 3是支付宝,4是微信
        indentInfo.setPayManner(3);
        log.info("the indentInfo is" + indentInfo);

        try {

            WXMessageUtil.setDomainUrl(request);
            /*String payFront = WXMessageUtil.domain + "/1.0/pay/front/" + indentCode;*/
//            String domin = "http://www.jnshu.com";
//            String domin = "http://test.skill.ptteng.com";
            String domin = "http://dev.pc.academy.ptteng.com";
            String payFront =domin+payFrontUrl;


            switch (type) {
                case PAY_ALI: {
                    String payBack = domin+"/pay/aliBack/" + indentCode;
                    log.info("get pay back url : " + payBack+" payFront = "+payFront);

                    if (null == indentInfo.getCreateAt()) {
                        indentInfo.setCreateAt(System.currentTimeMillis());
                    }


                    String outHtml = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), indentInfo.getTotalMoney().toString(), "", payFront,
                            payBack, PAY_ALI);

                    request.setAttribute("outHtml", outHtml);
                    log.info("outHtml :" + outHtml);
                    response.setContentType("text/html; charset=utf-8");

                    return "/pay/view/aliPaySure";
                }
                case PAY_LL: {
                    String payBack = WXMessageUtil.domain + "/pay/llBack/" + indentCode;
                    String req_data = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), indentInfo.getTotalMoney().toString(), "", payFront,
                            payBack, PAY_LL);

                    response.setContentType("text/html; charset=utf-8");

                    request.setAttribute("req_data", req_data);
                    log.info("req_data :" + req_data);

                    request.setAttribute("req_url", payOrderService.getParam("SERVER_URL", PAY_LL));
                    log.info("req_url :" + payOrderService.getParam("SERVER_URL", PAY_LL));

                    response.setContentType("text/html; charset=utf-8");

                    return "/pay/view/paySure";
                }
                case PAY_YINl: {
                    String totalMoney = new Double(indentInfo.getTotalMoney() * 100).intValue() + "";
                    log.info("  totalMoney  =  " + totalMoney);
                    String payBack = WXMessageUtil.domain + "/pay/ylback/" + indentCode;

                    String outHtml = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(System.currentTimeMillis(),
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), totalMoney, "", payFront,
                            payBack, PAY_YINl);
                    //   model.addAttribute("outHtml", outHtml);
                    request.setAttribute("outHtml", outHtml);
                    log.info("outHtml :" + outHtml);
                    response.setContentType("text/html; charset=utf-8");
                    return "/pay/view/aliPaySure";
                }
                case PAY_TONGL: {
                    String totalMoney = new Double(indentInfo.getTotalMoney() * 100).intValue() + "";
                    log.info("  totalMoney  =  " + totalMoney);

                    //测试用
                    String payBack = domin+"/pay/tonglback/" + indentCode;

                    log.info("get pay back url : " + payBack);
                    String outHtml = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), totalMoney, "", payFront,
                            payBack, PAY_TONGL);
                    //   model.addAttribute("outHtml", outHtml);
                    request.setAttribute("outHtml", outHtml);
                    log.info("outHtml :" + outHtml);
                    response.setContentType("text/html; charset=utf-8");
                    return "/pay/view/aliPaySure";
                }
                case PAY_XINGYE: {


                    String totalMoney = new Double(indentInfo.getTotalMoney() * 100).intValue() + "";
                    log.info("  totalMoney  =  " + totalMoney);
                  //  payFront = WXMessageUtil.domain + "/1.0/pay/tonglpay/front/" + indentCode;
                    log.info(" payFront = " + payFront);
                    String payBack = WXMessageUtil.domain + "/1.0/pay/tonglback/" + indentCode;
                    //测试用
                    payBack = "http://my.bolitian.com/1.0/pay/xingyeBack/" + indentCode;

                    log.info("get pay back url : " + payBack);
                    String result = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), totalMoney, indentInfo.getGoodsName(), payFront,
                            payBack, PAY_XINGYE);
                    log.info("  result = " + result);
                    XingyeResult xingyeResult =   GsonUtil.fromJson(result, XingyeResult.class);
                    if("0".equals(xingyeResult.getCode())){
                        model.addAttribute("code",0);
                        model.addAttribute("imgUrl",xingyeResult.getImgUrl());
                    }else{
                        model.addAttribute("code",-1);
                        model.addAttribute("errCode",xingyeResult.getErrCode());
                        model.addAttribute("message",xingyeResult.getMessage());
                    }


                    return "/data/XingyeJson";
                }

                case PAY_CAIFUTONG: {
                    log.info("  caifutong  ");
                    log.info(" payFront = " + payFront+"  createAt = "+indentInfo.getCreateAt()+" aa = "+
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                            "yyyyMMddHHmmss"));
                    Long payAt = System.currentTimeMillis();
                    String result = payOrderService.pay(indentInfo.getUserId() + "", indentCode,
                            MyTimeUtil.convertLong2String(payAt,
                                    "yyyyMMddHHmmss"), indentInfo.getGoodsName(), indentInfo.getTotalMoney().toString(), indentInfo.getGoodsName(), payFront,
                            "", PAY_CAIFUTONG);
                    Boolean updateResult =  indentInfoService.setPayAt(indentCode, payAt);
                    log.info("  updateResult  = "+updateResult);

                    log.info("  result = " + result);
                    request.setAttribute("outHtml", result);
                    log.info("outHtml :" + result);
                    response.setContentType("text/html; charset=utf-8");
                    return "/pay/view/aliPaySure";
                }


            }
        } catch (Exception e) {
            log.info("error : " + e.getMessage());
            e.printStackTrace();
            model.addAttribute("code", -1);
            return "/data/json";
        }
        return "";
    }


    /*
*
* */
    @RequestMapping(value = "/payment/{type}", method = RequestMethod.GET)
    public String payment(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable String type,
                          String indentCode, String payFrontUrl) throws Exception {
        log.info("/a/payment/" + type + "     indentCode : " + indentCode);

//        String indentInfoJsonStr = indentInfoService.getIndentByIndentCode(indentCode);
//
//        if (indentInfoJsonStr.equals("100")) {
//            model.addAttribute("code", 100);
//            model.addAttribute("message", "订单超时");
//            return "/data/json";
//        }
//
//        IndentInfo indentInfo =
//                GsonUtil.fromJson(indentInfoJsonStr, IndentInfo.class);

        IndentInfo indentInfo = new IndentInfo();
        indentInfo.setUserId(88L);
        //indentCode = "45454";
        indentInfo.setCreateAt(System.currentTimeMillis());
        indentInfo.setGoodsName("16G玫瑰金");
        indentInfo.setTotalMoney(0.01D);
        indentInfo.setToBankNo("105100000017");//
        indentInfo.setAcctType("0");
        indentInfo.setToAcctNo("6222801234567888953");
        indentInfo.setToAcctName("张三");

        try {

            WXMessageUtil.setDomainUrl(request);
            /*String payFront = WXMessageUtil.domain + "/1.0/pay/front/" + indentCode;*/
            String payFront = payFrontUrl/* + indentCode*/;

            log.info("payFront : " + payFront);

            switch (type) {

                case PAY_CAIFUTONG: {
                    log.info("  caifutong  ");
                    log.info(" payFront = " + payFront + "  createAt = " + indentInfo.getCreateAt() + " aa = " +
                            MyTimeUtil.convertLong2String(indentInfo.getCreateAt(),
                                    "yyyyMMddHHmmss"));
                    String result = payOrderService.pyPay(indentCode, indentInfo.getToBankNo(),
                            indentInfo.getToAcctNo(), indentInfo.getToAcctName(), indentInfo.getAcctType(),
                            indentInfo.getTotalMoney().toString(), indentInfo.getTransUsage(), PAY_CAIFUTONG);
                    log.info(" result = " + result);
                    if ("-1".equals(result)) {
                        model.addAttribute("code", -1);
                        log.info(" result =  -1  " + result);
                    } else {
                        XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
                        String transStatus = xingyeResult.getTransStatus();
                        if ("1".equals(transStatus)) {
                            model.addAttribute("code", 0);
                            //支付成功
                            model.addAttribute("tradeState", 1);
                            //需要修改订单状态--改为支付成功
                            //indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PayBackController.PAY_MANNER_UNIONPAY);

                        } else if ("2".equals(transStatus)) {
                            model.addAttribute("code", 0);
                            //支付失败
                            model.addAttribute("tradeState", 2);
                            //需要修改订单状态--改为转账失败
                            //indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE,PayBackController.PAY_MANNER_UNIONPAY);
                        } else {
                            model.addAttribute("code", 0);
                            //支付待支付
                            //需要修改订单状态--改为转账未完成
                            model.addAttribute("tradeState", 3);
                            model.addAttribute("errCode", xingyeResult.getErrcode());
                            model.addAttribute("message", xingyeResult.getErrmsg());
                        }
                    }

                }
                return "/data/XingyeJson";
            }
        } catch (Exception e) {
            log.info("error : " + e.getMessage());
            e.printStackTrace();
            model.addAttribute("code", 8);
            return "/data/json";
        }
        return "";
    }


    /**
     * 快捷支付认证接口
     *
     * @param request
     * @param response
     * @param model
     * @param trac_no    系统跟踪号
     * @param acct_type  银行账户类型
     * @param bank_no    银行代码
     * @param card_no    卡号
     * @param user_name  姓名
     * @param cert_no    证件号
     * @param card_phone 银行预留手机号码
     * @param expireDate
     * @param cvn
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/pay/kj/prove", method = RequestMethod.POST)
    public String epAuthSyncWithSms(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                    String trac_no, String acct_type, String bank_no,
                                    String card_no, String user_name, String cert_no,
                                    String card_phone, String expireDate, String cvn) throws Exception {
        log.info(" epAuthSyncWithSms start ...  ");
        if (StringUtil.isEmpty(trac_no) || StringUtil.isEmpty(card_no)
                || StringUtil.isEmpty(acct_type) || StringUtil.isEmpty(user_name)
                || StringUtil.isEmpty(cert_no) || StringUtil.isEmpty(card_phone)) {
            model.addAttribute("code", -2);
            return "/data/success";
        }
        String result = payOrderService.epAuthSyncWithSms(trac_no, acct_type, bank_no, card_no, user_name,
                cert_no, card_phone, expireDate, cvn, PAY_Cftkj);
        log.info(" result = " + result);
        if ("-1".equals(result)) {
            //查询失败
            log.info("  code = -1");
            model.addAttribute("code", -1);
            return "/data/success";
        } else {
            XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
            log.info(" errcode  = " + xingyeResult.getErrcode() + " message = " + xingyeResult.getErrmsg());
            if (StringUtil.isEmpty(xingyeResult.getErrcode())) {
                //发送短信成功
                model.addAttribute("result", 0);
            } else {
                //发送短信失败
                model.addAttribute("result", 1);
                model.addAttribute("errcode", xingyeResult.getErrcode());
                model.addAttribute("errmsg", xingyeResult.getErrmsg());
            }
        }
        model.addAttribute("code", 0);
        return "/data/success";
    }

    /**
     * 快捷支付短信验证接口
     *
     * @param request
     * @param response
     * @param model
     * @param trac_no
     * @param sms_code
     * @return
     */
    @RequestMapping(value = "/pay/kj/message", method = RequestMethod.GET)
    public String epAuthCheckSms(HttpServletRequest request, HttpServletResponse response,
                                 ModelMap model, String trac_no, String sms_code) {
        if (StringUtil.isEmpty(trac_no) || StringUtil.isEmpty(sms_code)) {
            model.addAttribute("code", -2);
            return "/data/success";
        }
        String result = payOrderService.epAuthCheckSms(trac_no, sms_code, PAY_Cftkj);
        log.info(" result = " + result);
        if ("-1".equals(result)) {
            //查询失败
            log.info("  code = -1");
            model.addAttribute("code", -1);
            return "/data/success";
        } else {
            XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
            log.info(" errcode  = " + xingyeResult.getErrcode() + " message = " + xingyeResult.getErrmsg());
            if (StringUtil.isEmpty(xingyeResult.getErrcode())) {
                //短信验证成功
                String auth_status = xingyeResult.getAuth_status();
                model.addAttribute("result", auth_status);
            } else {
                //短信验证失败
                model.addAttribute("result", 30);
                model.addAttribute("errcode", xingyeResult.getErrcode());
                model.addAttribute("errmsg", xingyeResult.getErrmsg());
            }
        }
        model.addAttribute("code", 0);
        return "/data/success";
    }

    /**
     * * 快捷支付账户认证结果查询接口
     *
     * @param trac_no  商户跟踪号
     * @param request
     * @param response
     * @param model
     * @return
     */
    @RequestMapping(value = "/pay/kj/query", method = RequestMethod.GET)
    public String epAuthQuery(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              String trac_no) {

        if (StringUtil.isEmpty(trac_no)) {
            model.addAttribute("code", -2);
            return "/data/success";
        }
        String result = payOrderService.epAuthQuery(trac_no, PAY_Cftkj);
        log.info(" result = " + result);
        if ("-1".equals(result)) {
            //查询失败
            log.info("  code = -1");
            model.addAttribute("code", -1);
            return "/data/success";
        } else {
            XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
            log.info(" errcode  = " + xingyeResult.getErrcode() + " message = " + xingyeResult.getErrmsg());
            if (StringUtil.isEmpty(xingyeResult.getErrcode())) {
                //短信验证成功
                String auth_status = xingyeResult.getAuth_status();
                model.addAttribute("result", auth_status);
            } else {
                //短信验证失败
                model.addAttribute("result", 30);
                model.addAttribute("errcode", xingyeResult.getErrcode());
                model.addAttribute("errmsg", xingyeResult.getErrmsg());
            }
        }
        model.addAttribute("code", 0);
        return "/data/success";

    }

    @RequestMapping(value = "/a/pay/hello", method = RequestMethod.GET)
    public String HelloTest(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        return "/index";
    }

    @RequestMapping(value = "/pay/check", method = RequestMethod.GET)
    public String orderResultQuery(HttpServletRequest request, HttpServletResponse response,
                                   ModelMap model, String indentCode) {

//        try {
//
////                    IndentInfo indentInfo = new IndentInfo();
////        indentInfo.setUserId(88L);
////        //indentCode = "45454";
////        indentInfo.setCreateAt(System.currentTimeMillis());
////        indentInfo.setGoodsName("16G玫瑰金");
////        indentInfo.setTotalMoney(0.01D);
////            indentInfo.setPayManner(100);
////            indentInfo.setStatus(OrderStatus.WAITFORPAY);
//            String indentInfoJsonStr = indentInfoService.getIndentByIndentCode(indentCode);
//            IndentInfo indentInfo =
//                    GsonUtil.fromJson(indentInfoJsonStr, IndentInfo.class);
//
//            if (!Integer.valueOf(OrderStatus.WAITFORPAY).equals(indentInfo.getStatus())) {
//                //如果不是待支付 //返回成功
//                model.addAttribute("code", 0);
//                model.addAttribute("tradeState", 1);
//                return "/data/XingyeJson";
//            } else {
//               // 如果是待支付，查银行
//            Integer payManner = indentInfo.getPayManner();//支付方式
//            log.info("  payManner = " + payManner);
//                if(null == payManner){
//                    model.addAttribute("code", 0);
//                    model.addAttribute("tradeState", 2);
//                    return "/data/XingyeJson";
//                }
//
//            switch (payManner) {
//                case Order.PAYMANNER_1: {
//
//                    break;
//                }
//
//                case Order.PAYMANNER_2: {
//                    log.info(" indentInfo.getPayAt()  = "+indentInfo.getPayAt());
//                    if(null == indentInfo.getPayAt() ){
//                        model.addAttribute("code", 0);
//                        model.addAttribute("tradeState", 2);
//                    }else {
//
//                        //银行卡
//                        String result = payOrderService.check(indentCode,
//                                MyTimeUtil.convertLong2String(indentInfo.getPayAt(),
//                                        "yyyyMMdd"), PAY_CAIFUTONG);
//
//                        log.info("  result json = " + result);
//                        XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
//
//                        if ("-1".equals(result)) {
//                            //查询失败
//                            log.info("  code = -1");
//                            model.addAttribute("code", -1);
//                        } else {
//                            //查询成功
//                            log.info("  code = 0");
//                            String trans_status = xingyeResult.getTrans_status();
//                            log.info("  trans_status = " + trans_status);
//                            model.addAttribute("code", 0);
//                            if (StringUtil.isEmpty(trans_status)) {
//                                model.addAttribute("tradeState", 2);
//                                model.addAttribute("errCode", xingyeResult.getErrcode());
//                                model.addAttribute("message", xingyeResult.getErrmsg());
//                            } else {
//                                if ("1".equals(trans_status)) {
//                                    //支付成功
//                                    model.addAttribute("tradeState", 1);
//                                    indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PayBackController.PAY_MANNER_UNIONPAY);
//
//                                } else if ("2".equals(trans_status)) {
//                                    //支付失败
//                                    model.addAttribute("tradeState", 2);
//                                    indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PayBackController.PAY_MANNER_UNIONPAY);
//                                } else {
//                                    //支付待支付
//                                    model.addAttribute("tradeState", 2);
//                                }
//
//                            }
//
//                        }
//
//                        return "/data/XingyeJson";
//                    }
//                }
//                case Order.PAYMANNER_3: {
//                    //支付宝
//                    boolean res = indentInfoService.AliPayStatusQuery(indentCode);
//
//                    if (res) {
//                        model.addAttribute("tradeState", 1);
//                        model.addAttribute("code", 0);
//                        indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PayBackController.PAY_MANNER_ALIPAY);
//                    } else {
//                        model.addAttribute("code", 0);
//                        model.addAttribute("tradeState", 2);
//                        model.addAttribute("message", "支付失败");
//                    }
//                    return "/data/XingyeJson";
//                }
//                case Order.PAYMANNER_4: {
//                    //微信
//
//                    String result = payOrderService.check(indentCode, "", PAY_XINGYE);
//                    log.info("  result = " + result);
//                    XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
//                    if ("0".equals(xingyeResult.getCode())) {
//                        log.info("  success ");
//                        model.addAttribute("code", 0);
//                        if ("SUCCESS".equals(xingyeResult.getTradeState())) {
//                            //支付成功
//                            model.addAttribute("tradeState", 1);
//                            indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PayBackController.PAY_MANNER_WEIXIN);
//                        } else if("PAYERROR".equals(xingyeResult.getTradeState())) {
//                            //支付失败
//                            model.addAttribute("tradeState", 2);
//                            indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PayBackController.PAY_MANNER_WEIXIN);
//                        }else{
//                            //待支付
//                            model.addAttribute("tradeState", 2);
//                        }
//                    } else {
//                        model.addAttribute("code", -1);
//                        model.addAttribute("errCode", xingyeResult.getErrCode());
//                        model.addAttribute("message", xingyeResult.getMessage());
//                    }
//
//                    return "/data/XingyeJson";
//
//                }
//                case 100: {
//                    //代付查询测试
//                    String result = payOrderService.checkPayment(indentCode, "", PAY_CAIFUTONG);
//                    log.info(" result = "+result);
//                    if("-1".equals(result)){
//                        //调用失败
//                        log.info(" result =  -1  " + result);
//
//                    }else{
//                        XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
//                        log.info(" xingyeResult = "+xingyeResult);
//                        String transStatus = xingyeResult.getTransStatus();
//                        if ("1".equals(transStatus)) {
//                            log.info(" success ");
//                            //提现成功
//                            //1：改状态：改为提现成功
//                            //indentInfoService.paymentStatus(fundId, fund.getuserId(),fund.getincome(),SUCCESS );
//                        } else if("2".equals(transStatus)) {
//                            log.info(" failure ");
//                            //提现失败
//
//                        }else{
//                            log.info(" waiting ");
//                            //支付待支付:未决
//                            //不修改订单状态
//
//                        }
//                    }
//                    return "/data/XingyeJson";
//
//                }
//                default:
//                    break;
//            }
//
//        }
//        } catch (ServiceException e) {
//            model.addAttribute("code", -1);
//            e.printStackTrace();
//        } catch (ServiceDaoException e) {
//            model.addAttribute("code", -1);
//            e.printStackTrace();
//        }
        return "/data/XingyeJson";
    }

}
