package com.qding.framework.pay.controller;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import atg.taglib.json.util.JSONObject;
import com.allinpay.ets.client.PaymentResult;
import com.gemantic.common.util.json.GsonUtil;
import com.google.gson.JsonNull;

import com.qding.common.pay.model.IndentInfo;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.community.util.IndentUtil;
import com.qding.community.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.gson.Gson;

import com.qding.common.pay.service.PayOrderService;


@Controller
public class PayBackController {

    @Autowired
    private PayOrderService payOrderService;

    @Autowired
    private IndentInfoService indentInfoService;

    private static final Log log = LogFactory.getLog(PayBackController.class);

    public static final Integer PAY_MANNER_UNIONPAY = 2;

    public static final Integer PAY_MANNER_ALIPAY = 3;

    public static final Integer PAY_MANNER_WEIXIN = 4;
    public static final Integer PAY_MANNER_TONGLIIAN = 5;
    public static final Integer PAY_MANNER_CFTKJ = 10;
    // public static final Integer PAY_MANNER_XINGYE = 6;


    @RequestMapping(value = "pay/front/{indentCode}", method = RequestMethod.GET)
    public String front(HttpServletRequest request,
                        HttpServletResponse response, ModelMap model,
                        @PathVariable String indentCode) throws Exception {

        log.info("pay  front indentCode :" + indentCode);
        //String indentInfoStr  = indentInfoService.getIndentByIndentCode(indentCode);
        //IndentInfo indentInfo = GsonUtil.fromJson(indentInfoStr,IndentInfo.class);

        String url = "";

        try {


            if (IndentUtil.Status_Pay_All == 4) {
                model.addAttribute("code", "00");
                url = "/pay/view/paySuccess";
            } else {
                model.addAttribute("code", "-1");
                url = "/pay/view/payFailure";
            }

        } catch (Exception e) {
            // TODO Auto-generated catch block
            log.error(" pay front error " + e.getMessage());
        }

        return url;
    }


    @RequestMapping(value = "pay/tonglpay/front/{indentCode}", method = RequestMethod.POST)
    public String tonglFront(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @PathVariable String indentCode) throws Exception {

        log.info("pay  front indentCode :" + indentCode);
        //String indentInfoStr  = indentInfoService.getIndentByIndentCode(indentCode);
        //IndentInfo indentInfo = GsonUtil.fromJson(indentInfoStr,IndentInfo.class);

        String url = "";

        try {


            if (IndentUtil.Status_Pay_All == 4) {
                model.addAttribute("code", "00");
                url = "/pay/view/paySuccess";
            } else {
                model.addAttribute("code", "-1");
                url = "/pay/view/payFailure";
            }

        } catch (Exception e) {
            // TODO Auto-generated catch block
            log.error(" pay front error " + e.getMessage());
        }

        return url;
    }


    @RequestMapping(value = "pay/back/{indentCode}", method = RequestMethod.POST)
    public String back(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @PathVariable String indentCode) throws Exception {

        log.info("pay  back indentCode:" + indentCode);
        String reqXml = "";
        InputStream inputStream = request.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(
                new InputStreamReader(inputStream));
        String tmpStr = "";
        while ((tmpStr = bufferedReader.readLine()) != null) {
            reqXml += tmpStr;
        }
        bufferedReader.close();
        inputStream.close();

        log.info("reqXml:" + reqXml);

        String xml = payOrderService.notice(reqXml, PayController.PAY_YL);

        org.dom4j.Document document = org.dom4j.DocumentHelper.parseText(xml);
        org.dom4j.Element upbp = document.getRootElement();

        String odCode = upbp.elementText("merchantOrderId");
        String code = upbp.elementText("cupsRespCode");
        String info = upbp.elementText("cupsRespDesc");

        log.info("order code :" + odCode + ",response code:" + code + ",info:"
                + info);
        // 支付成功
        if ("00".equals(code)) {
            // 通知状态
            indentInfoService.noticeBack(odCode, IndentUtil.SUCCESS, 0);
        } else {
            indentInfoService.noticeBack(odCode, IndentUtil.FAILURE, 0);

        }

        return "";
    }

    @RequestMapping(value = "pay/ylback/{indentCode}", method = RequestMethod.POST)
    public String ylBack(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model,
                         @PathVariable String indentCode) throws Exception {

        log.info("pay  back indentCode:" + indentCode);
        request.setCharacterEncoding("ISO-8859-1");
        String encoding = request.getParameter("encoding");
        // 获取银联通知服务器发送的后台通知参数
        Map<String, String> reqParam = getAllRequestParam(request);
        log.info("   reqParam  = " + reqParam);


        Map<String, String> valideData = null;
        if (null != reqParam && !reqParam.isEmpty()) {
            Iterator<Map.Entry<String, String>> it = reqParam.entrySet().iterator();
            valideData = new HashMap<String, String>(reqParam.size());
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String key = (String) e.getKey();
                String value = (String) e.getValue();
                value = new String(value.getBytes("ISO-8859-1"), encoding);
                valideData.put(key, value);
            }
        }


        Boolean result = payOrderService.ylnotice(valideData, encoding, PayController.PAY_YINl);

        log.info("  验证签名  result  =   :" + result);

        if (result) {
            log.info(" 验证签名  success  ");
            String respCode = valideData.get("respCode");//获取应答码，收到后台通知了respCode的值一般是00
            // 支付成功
            if ("00".equals(respCode)) {
                // 通知状态
                indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PAY_MANNER_UNIONPAY);
            } else {
                indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PAY_MANNER_UNIONPAY);

            }

        } else {
            log.info("  验证签名  failure  ");
        }


        return "";
    }

    /**
     * 获取请求参数中所有的信息
     *
     * @param request
     * @return
     */
    public static Map<String, String> getAllRequestParam(final HttpServletRequest request) {
        Map<String, String> res = new HashMap<String, String>();
        Enumeration<?> temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String) temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                //在报文上送时，如果字段的值为空，则不上送<下面的处理为在获取所有参数数据时，判断若值为空，则删除这个字段>
                //System.out.println("ServletUtil类247行  temp数据的键=="+en+"     值==="+value);
                if (null == res.get(en) || "".equals(res.get(en))) {
                    res.remove(en);
                }
            }
        }
        return res;
    }


    /**
     * 从库存中减去支付成功的货品数量
     *
     * @throws ServiceException
     * @throws ServiceDaoException
     */
//	private void resetGoodsNumber(Long id) throws ServiceException,
//			ServiceDaoException {
//		List<Long> ids = this.gorderGoodsRelationService
//				.getGorderGoodsRelationIdsByGorderID(id, 0, Integer.MAX_VALUE);
//
//		log.info(" update goods count , relation ids " + ids);
//
//		List<GorderGoodsRelation> ggrList = this.gorderGoodsRelationService
//				.getObjectsByIds(ids);
//
//		log.info(" update goods count , relation size " + ggrList.size());
//
//		List<Long> gids = new ArrayList<>();
//		Map<Long, Integer> numberMap = new HashMap<>();
//		for (GorderGoodsRelation ggr : ggrList) {
//			gids.add(ggr.getGoodsID());
//			numberMap.put(ggr.getGoodsID(), ggr.getCount());
//		}
//
//		log.info("update goods count  ids " + gids);
//
//		List<Goods> goodsList = this.goodsService.getObjectsByIds(gids);
//
//		log.info("update goods count , goods size " + goodsList.size());
//
//		for (Goods goods : goodsList) {
//			if (goods.getCount() != -1) {
//				goods.setCount(goods.getCount() - numberMap.get(goods.getId()));
//			}
//		}
//
//		goodsService.updateList(goodsList);
//	}
    @RequestMapping(value = "pay/llBack/{indentCode}", method = RequestMethod.POST)
    public String llBack(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model,
                         @PathVariable String indentCode, @RequestBody String res_data)
            throws Exception {

        log.info("payback orderCode : " + indentCode);
        log.info("payback res_data : " + res_data);

        String result = payOrderService.notice(res_data, PayController.PAY_LL);

        if (null == result) {
            log.info("user  cancel  pay");
        } else {
            String indentInfoStr = indentInfoService.getIndentByIndentCode(indentCode);

            IndentInfo indentInfo = GsonUtil.fromJson(indentInfoStr, IndentInfo.class);
            log.info("gorder old status :" + indentInfo.getStatus());

            switch (result) {
                case "SUCCESS":
                    // 通知状态
                    indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, 0);
                    break;
                case "PROCESSING":
                    break;
                case "FAILURE":
                    indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, 0);
                    break;
                case "REFUND":
                    break;
            }
        }

        model.addAttribute("ret_code", "0000");
        model.addAttribute("ret_msg", "交易成功");
        return "/pay/json/json";
    }



    @RequestMapping(value = "pay/aliBack/{indentCode}", method = RequestMethod.POST)
    public String aliBack(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model,
                          @PathVariable String indentCode, @RequestBody String data) throws Exception {

        log.info("payback orderCode : " + indentCode + ",data : " + data);

        Map<String, String> params = new HashMap<String, String>();
        String[] kv = data.split("&");
        for (String s : kv) {
            String[] tmp = s.split("=");
            params.put(tmp[0], tmp[1]);
        }

        String result = payOrderService.notice(GsonUtil.toJson(params),
                PayController.PAY_ALI);

        log.info("pay result " + result);

        String status = GsonUtil.get("tradeStatus", result);

        log.info("pay status " + status);

        String indentInfoStr = indentInfoService.getIndentByIndentCode(indentCode);
        IndentInfo indentInfo = GsonUtil.fromJson(indentInfoStr, IndentInfo.class);


        log.info("gorder old status :" + indentInfo.getStatus());

        //status = "SUCCESS";

        switch (status) {
            case "FINISHED": //交易成功且结束，即不可再做任何操作
            case "SUCCESS": //交易成功，且可对该交易做操作，如：多级分润、退款等。
                indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PAY_MANNER_ALIPAY);
                log.info("order aready success!!!");
                break;
            case "FAILURE":
                indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PAY_MANNER_ALIPAY);
                log.info("order aready failure!!!");

                break;
        }

        return "";
    }

    @RequestMapping(value = "pay/tonglback/{indentCode}", method = RequestMethod.POST)
    public String tonglback(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model,
                            @PathVariable String indentCode) throws Exception {

        log.info("  tonglback    payback orderCode : " + indentCode);
        PaymentResult paymentResult = new PaymentResult();
        paymentResult.setMerchantId(request.getParameter("merchantId"));
        paymentResult.setVersion(request.getParameter("version"));
        paymentResult.setLanguage(request.getParameter("language"));
        paymentResult.setSignType(request.getParameter("signType"));
        String signType = request.getParameter("signType");
        log.info("  signType =  "+signType);
        paymentResult.setPayType(request.getParameter("payType"));
        paymentResult.setPaymentOrderId(request.getParameter("paymentOrderId"));
        paymentResult.setOrderNo(request.getParameter("orderNo"));
        paymentResult.setOrderDatetime(request.getParameter("orderDatetime"));
        paymentResult.setOrderAmount(request.getParameter("orderAmount"));
        paymentResult.setPayDatetime(request.getParameter("payDatetime"));
        paymentResult.setPayAmount(request.getParameter("payAmount"));
        paymentResult.setExt1(request.getParameter("ext1"));
        paymentResult.setExt2(request.getParameter("ext2"));
        paymentResult.setPayResult(request.getParameter("payResult"));
        paymentResult.setErrorCode(request.getParameter("errorCode"));
        paymentResult.setReturnDatetime(request.getParameter("returnDatetime"));
        //signMsg为服务器端返回的签名值。
        paymentResult.setSignMsg(request.getParameter("signMsg"));
        //signType为"1"时，必须设置证书路径。
        if("1".equals(signType)){
            String path = this.getClass().getResource("/").getPath();
            log.info("  path = " + path);
            //测试先这样，在线上环境单独配一个路径
            paymentResult.setCertPath("allinpay-pds.cer");
        }

        //验证签名：返回true代表验签成功；否则验签失败。
        boolean verifyResult = paymentResult.verify();

        //验签成功，还需要判断订单状态，为"1"表示支付成功。
        log.info("  result  =  " + paymentResult.getPayResult());
        boolean paySuccess = verifyResult && paymentResult.getPayResult().equals("1");

        log.info("pay paySuccess " + paySuccess);
        if (paySuccess) {
            log.info("  success ");
            indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PAY_MANNER_TONGLIIAN);
        } else {
            log.info("  failure ");
            indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PAY_MANNER_TONGLIIAN);
        }

        return "";
    }


    @RequestMapping(value = "pay/xingyeBack/{indentCode}", method = RequestMethod.POST)
    public String xingyeBack(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model,
                             @PathVariable String indentCode, @RequestBody String data) throws Exception {

        log.info("payback orderCode : " + indentCode + ",data : " + data);
        Map map = XmlUtil.doXMLParse(data);
        String pay_result = "";
        String status = (String) map.get("status");

        if ("0".equals(status)) {
            String resultCode = (String) map.get("result_code");
            if ("0".equals(resultCode)) {
                pay_result = (String) map.get("pay_result");
            } else {
                log.info("  error message   " + (String) map.get("err_msg"));
                pay_result = "-1";
            }

        } else {
            log.info("  error message   " + (String) map.get("message"));
            pay_result = "-1";
        }
        if ("0".equals(pay_result)) {
            log.info("  success ");
            model.addAttribute("outHtml", "success");
            indentInfoService.noticeBack(indentCode, IndentUtil.SUCCESS, PAY_MANNER_WEIXIN);
        } else {
            log.info("  failure ");
            model.addAttribute("outHtml", "fail");
            indentInfoService.noticeBack(indentCode, IndentUtil.FAILURE, PAY_MANNER_WEIXIN);
        }

        log.info(" ");
        return "/pay/view/aliPaySure";
    }
    @RequestMapping(value = "pay/cftBack", method = RequestMethod.POST)
    public String cftBack(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model
                            ) throws Exception {

        log.info("cftBack  orderCode : " + request.getParameter("order_no") );

        Map<String,String> params = new HashMap<String,String>();
        Map<?, ?> reqParams = request.getParameterMap();
        Iterator<?> iter = reqParams.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String) iter.next();
            String[] values = (String[]) reqParams.get(name);
            params.put(name, values[0]);
        }
        log.info("  order_no = " + params.get("order_no"));

        Boolean result =     payOrderService.ylnotice(params,"",PayController.PAY_CAIFUTONG);
        log.info("  result = "+result);
        if(result){
            log.info("  mac  success ");
            if("NOTIFY_ACQUIRE_SUCCESS".equalsIgnoreCase(params.get("event"))) {		//支付成功通知
                //支付成功业务逻辑处理
                log.info("  success ");
                indentInfoService.noticeBack(params.get("order_no"), IndentUtil.SUCCESS, PAY_MANNER_UNIONPAY);

            } else if("NOTIFY_ACQUIRE_FAIL".equalsIgnoreCase(params.get("event")))	{	//支付失败通知
                //支付失败业务逻辑处理
                log.info("  failure ");
                indentInfoService.noticeBack(params.get("order_no"), IndentUtil.FAILURE, PAY_MANNER_UNIONPAY);
            }
        }else{
            log.info("  mac  failure ");
            log.info("  failure ");
            indentInfoService.noticeBack(params.get("order_no"), IndentUtil.FAILURE, PAY_MANNER_UNIONPAY);
        }


        log.info(" finish  ");
        return "";
    }

}
