package com.qding.common.pay.service.impl;

import com.qding.common.pay.service.PayOrderService;
import com.qding.common.pay.util.cft.DateTimeUtil;
import com.qding.common.pay.util.cft.IPostService;
import com.qding.common.pay.util.cft.Signature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liangxj on 2016/5/5.
 */
public class CftkjPayServiceImpl implements PayOrderService {
    private static final Log log = LogFactory
            .getLog(CaifutongPayServiceImpl.class);
    private Map<String, String> cftPayConfig;

    public Map<String, String> getCftPayConfig() {
        return cftPayConfig;
    }

    public void setCftPayConfig(Map<String, String> cftPayConfig) {
        this.cftPayConfig = cftPayConfig;
    }


    @Override
    public String payTest(String code, String type) {
        return null;
    }

    @Override
    public String pay(String userid, String merchantOrderId, String merchantOrderTime, String merchantOrderName, String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String type) {
        return null;
    }

    @Override
    public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name, String acct_type, String trans_amt, String trans_usage, String type) {
        return null;
    }

    @Override
    public String notice(String xmlString, String type) {
        return null;
    }

    @Override
    public boolean ylnotice(Map<String, String> reqData, String encoding, String type) {
        return false;
    }

    @Override
    public String check(String merchantOrderId, String merchantOrderTime, String type) {
        return null;
    }

    @Override
    public String checkPayment(String merchantOrderId, String merchantOrderTime, String type) {
        return null;
    }

    @Override
    public String getParam(String key, String type) {
        return null;
    }

    /**
     * 快捷支付认证接口（同步接口，需短信确认）
     *
     * @param trac_no    商户跟踪号
     * @param acct_type  卡类型：0-储蓄卡,1-信用卡
     * @param bank_no    人行联网行号
     * @param card_no    账号
     * @param user_name  姓名
     * @param cert_no    证件号码
     * @param card_phone 联系电话
     * @param expireDate 信用卡有效期（仅信用卡时必输，格式MMYY）
     * @param cvn        信用卡CVN（仅信用卡时必输）
     * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
     */
    public  String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn,String type) {

        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trac_no", trac_no);
        params.put("acct_type", acct_type);
        if (bank_no != null && !("".equals(bank_no)))
            params.put("bank_no", bank_no);
        params.put("card_no", card_no);
        params.put("user_name", user_name);
        params.put("cert_no", cert_no);
        params.put("card_phone", card_phone);
        if (expireDate != null) params.put("expireDate", expireDate);
        if (cvn != null) params.put("cvn", cvn);

        params.put("appid",cftPayConfig.get("appid"));
        params.put("service", cftPayConfig.get("service_auth"));
        params.put("ver", cftPayConfig.get("ver_auth"));
        params.put("cert_type",  "0");//证件类型 0-身份证(目前仅支持身份证)
        params.put("timestamp", DateTimeUtil.getDateTime());
        params.put("sign_type", cftPayConfig.get("sign_type_pyPay"));
        params.put("mac", Signature.generateMAC(params,cftPayConfig.get("commKey"), cftPayConfig.get("mrch_cert"), cftPayConfig.get("mrch_cert_pwd")));



        return IPostService.txn(cftPayConfig.get("server_auth2"), params, cftPayConfig.get("commKey"), cftPayConfig.get("epay_cert_prod"));

    }

    /**
     * 快捷认证短信验证码确认接口
     *
     * @param trac_no  发起同步认证时的商户跟踪号
     * @param sms_code 6位数字短信验证码
     * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
     */
    public  String epAuthCheckSms(String trac_no, String sms_code,String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trac_no", trac_no);
        params.put("sms_code", sms_code);

        params.put("appid", cftPayConfig.get("appid"));
        params.put("service", cftPayConfig.get("service_sms"));
        params.put("ver", cftPayConfig.get("ver_sms"));
        params.put("timestamp", DateTimeUtil.getDateTime());
        params.put("sign_type",  cftPayConfig.get("sign_type_pyPay"));
        params.put("mac", Signature.generateMAC(params,cftPayConfig.get("commKey"), cftPayConfig.get("mrch_cert"), cftPayConfig.get("mrch_cert_pwd")));
        return IPostService.txn(cftPayConfig.get("server_auth2"), params, cftPayConfig.get("commKey"), cftPayConfig.get("epay_cert_prod"));
    }

    @Override
    public String epAuthQuery(String trac_no, String type) {

        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trac_no", trac_no);
        params.put("appid",  cftPayConfig.get("appid"));
        params.put("service", cftPayConfig.get("service_auth_query"));
        params.put("ver",  cftPayConfig.get("ver_auth_query"));
        params.put("timestamp", DateTimeUtil.getDateTime());
        params.put("sign_type",  cftPayConfig.get("sign_type"));
        params.put("mac", Signature.generateMAC(params,cftPayConfig.get("commKey"),"",""));

        return IPostService.txn(cftPayConfig.get("server_auth2"), params, cftPayConfig.get("commKey"), "");

    }

}
