package com.qding.common.pay.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

import java.util.Map;
import org.osoa.sca.annotations.Remotable;
/**
 * Created by liangxj on 2016/3/10.
 */
@Remotable
public interface IndentInfoService {
    /**
     * 根据订单号查询订单详细信息
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException key  totalMoney--金额
     *                             province--省
     *                             city---市
     *                             county-县
     *                             addressDetail--地址详细信息
     *                             receiverName--收货人姓名
     *                             receiveMobile--收货人手机号
     *                             goodsName--商品名称
     *                             status--订单状态  int类型
     *                             userId--用户ID
     */
    public String getIndentByIndentCode(String indentCode)
            throws ServiceException, ServiceDaoException;


    /**
     * 回调service，入参订单号和状态
     */
    public void noticeBack(String indentCode, int respCode, int payManner)
            throws ServiceException, ServiceDaoException;


    public Boolean setPayAt(String orderId,Long payAt);


}
