package com.ptteng.academy.home.util;


import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.Notice;
import com.ptteng.common.dao.util.SQLUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.map.HashedMap;

import java.util.*;

/**
 * Created by liangxj on 2015/9/7.
 */
public class
DynamicUtil {

	public static Map<String, Object> getDocumentList(Integer type, String title) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put("title & like", " '%" + title + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("type", type);
		}

		params.put("status", 1);
		params.put("@order", "rank asc ,order_by asc, create_at desc ");
		params.put("@query", " id");

		params.put("@table", " document ");

		return params;
	}


	public static Map<String, Object> getVideoList(Integer type, String title, Integer grade, Integer subject) {
		Map<String, Object> params = new HashedMap();
		Set<String> tables = new HashSet();
		tables.add("video");
		if (DataUtils.isNotNullOrEmpty(title)) {
			params.put("video.title & like", " '%" + title + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(type)) {
			params.put("video.type", "'" +type + "'");
		}

		if (DataUtils.isNotNullOrEmpty(subject)) {
			params.put("video.subject", "'"+subject + "'");
		}
		if (DataUtils.isNotNullOrEmpty(grade)) {
			tables.add("video_grade_relation as vgr");
			params.put("video.id","vgr.video_id");
			params.put("vgr.grade", "'" +grade + "'" );
		}

		if (Video.Type_Banner.equals(type)) {
			params.put("@order", " video.rank asc,video.order_by asc, video.create_at desc ");
		} else {
			params.put("@order", "video.rank asc, video.create_at desc ");
		}


		params.put("video.status", 1);
//		params.put("@order", " video.rank asc, video.order_by asc, video.create_at desc ");
		params.put("@query", " video.id");

		String table = SQLUtil.convertTable(tables);
		params.put("@table", table);

		return params;
	}


	public static Map<String, Object> getMessageList(Integer grade, String name, Integer messageType, String nick, Long timeLow, Long timeHigh, String mail, Integer type, Long userId) {
		Map<String, Object> params = new HashedMap();
		if (DataUtils.isNotNullOrEmpty(name)) {
			params.put("name & like", " '%" + name + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(mail)) {
			params.put("mail & like", " '%" + mail + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(nick)) {
			params.put("nick & like", " '%" + nick + "%'");
		}
		if (DataUtils.isNotNullOrEmpty(messageType)) {
			params.put("message_type", "'" + messageType + "'");
		}
		if (DataUtils.isNotNullOrEmpty(timeLow)) {
			params.put("create_at&>", "'" + timeLow + "'");
		}

		if (DataUtils.isNotNullOrEmpty(type) && DataUtils.isNotNullOrEmpty(userId)) {
			if (type == 1) {
				if (grade == 7) {
					params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + "))");

				} else {
					params.put("&((type =", "'" + 1 + "' and grade =7)  or  (type=4 and user_id =" + userId + ") or  (type=1 and grade = " + grade + "))");

					System.out.println(grade);
				}

			} else {
				params.put("type", "'" + type + "'");
			}
		}

		if (DataUtils.isNotNullOrEmpty(timeHigh)) {
			params.put("create_at&<", "'" + timeHigh + "'");
		}
		params.put("up_down", 1);
		if (Message.Type_Help.equals(type)) {
			params.put("@order", "  sort asc ");

		} else {
			params.put("@order", "  publish_at desc ");

		}
		params.put("@query", " id");

		params.put("@table", " message ");
		return params;
	}

	public static Map<String, Object> getUserMessageList(Long targetId, Long userId, Integer userRead) {
		Map<String, Object> params = new HashedMap();

		if (DataUtils.isNotNullOrEmpty(targetId)) {
			params.put("target_id", " '" + targetId + "'");
		}

		if (DataUtils.isNotNullOrEmpty(userId)) {
			params.put("user_id", " '" + userId + "'");
		}
		if (DataUtils.isNotNullOrEmpty(userRead)) {
			params.put("user_read", " '" + userRead + "'");
		}

		params.put("@order", "  create_at desc ");
		params.put("@query", " id");

		params.put("@table", " user_message_relation ");

		return params;
	}

	//前台公告
	public static Map<String, Object> getNotice() {

		Map<String, Object> params = new HashMap<>();
		params.put("status", Notice.NOTICE_UP);
		params.put("@table", "notice");
		params.put("@query", "id");
		return params;
	}

	//得到会员套餐列表
	public static Map<String, Object> getMemberList(boolean count) {
		Map<String, Object> params = new HashedMap();
		params.put("status", Member.STATUS_UP);

		if (count) {
			params.put("@query", " count(id)");

		} else {
			params.put("@order", " recommend asc,  period asc ");
			params.put("@query", " id");
		}


		params.put("@table", " member ");

		return  params;
	}

	//查询科目下面是否有上架视频
	public static Map<String, Object> getSubjectVideoStatus(Integer subject) {
		Map<String, Object> params = new HashedMap();
		params.put("subject",  subject);
		params.put("status", Video.Status_Published);
		params.put("@query", " count(id)");
		params.put("@table", " video ");
		return  params;
	}



}