package com.ptteng.academy.home.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.UserOpenidRelation;
import com.ptteng.academy.user.model.UserOrder;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.UserOpenidRelationService;
import com.ptteng.academy.user.service.UserOrderService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.academy.home.constant.WxConstantConfig;
import com.ptteng.academy.home.util.MD5;
import com.ptteng.academy.home.util.ThreePartPropertiesUtil;
import com.ptteng.academy.home.util.XmlUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.json.GsonUtil;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.vo.JSAPI;
import com.qding.community.common.weixin.vo.WXUser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;


@Controller
public class WxMessageController {

    private static final Log log = LogFactory.getLog("wx");

    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private HttpClientUtil httpClientUtil;
    @Autowired
    private ImgStorageUtil imgStorageUtil;
    @Autowired
    private UserOrderService userOrderService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;


    /**
     * 网址接入
     *
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/wx", method = RequestMethod.GET)
    public String doGet(HttpServletRequest request, ModelMap model, HttpServletResponse response, String signature,
                        String timestamp, String nonce, String echostr) throws Exception {
        log.info("signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce + ",echostr=" + echostr);

        if (null != timestamp && null != nonce && null != echostr && null != signature
                && weixinService.access(WxConstantConfig.token, signature, timestamp, nonce)) {

        } else {
            log.warn("请求来源校验失败, signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce);
        }
        log.info(echostr);

        model.addAttribute("echostr", echostr);
        return "/weixin/token/show";
    }

    //1、code获取openid、用户信息
    @RequestMapping(value = "/a/openid", method = RequestMethod.GET)
    public String getOpenid(HttpServletRequest request, HttpServletResponse response, ModelMap model, String code) {
        log.info(" code : " + code + " get openid ");

        try {
            String url = WxConstantConfig.token_url + "?appid=" + WxConstantConfig.appid + "&secret=" + WxConstantConfig.secret + "&code=" + code + "&grant_type=" + WxConstantConfig.grant_type;
            log.info("token url is " + url);

            String httpsresponse = httpClientUtil.sendGetRequest(url, "utf-8");
            log.info(code + " get access_token result is " + httpsresponse);

            String errcode = GsonUtil.get("errcode", httpsresponse);
            String errmsg = GsonUtil.get("errmsg", httpsresponse);
            if (DataUtils.isNotNullOrEmpty(errcode)) {
                model.addAttribute("code", errcode);
                model.addAttribute("message", errmsg);
                return "/common/result";
            }

            String accessToken = GsonUtil.get("access_token", httpsresponse);
            String openid = GsonUtil.get("openid", httpsresponse);
            log.info("accessToken is " + accessToken);
            log.info("openid is " + openid);

            String userUrl = WxConstantConfig.userInfo_url + "?access_token=" + accessToken + "&openid=" + openid + "&lang=zh_CN";
            log.info("uerInfo url is " + userUrl);
            String userhttpsresponse = httpClientUtil.sendGetRequest(userUrl, "utf-8");
            log.info(code + " get user info result is " + userhttpsresponse);

            errcode = GsonUtil.get("errcode", httpsresponse);
            errmsg = GsonUtil.get("errmsg", httpsresponse);
            if (DataUtils.isNotNullOrEmpty(errcode)) {
                model.addAttribute("code", errcode);
                model.addAttribute("message", errmsg);
                return "/common/result";
            }

            Gson gson = (new GsonBuilder()).create();
            WXUser user = gson.fromJson(userhttpsresponse, WXUser.class);
            log.info("user : " + user);

            model.addAttribute("code", 0);
            model.addAttribute("openid", openid);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            log.error("get openid error ");
            t.printStackTrace();
        }
        return "/weixin/token/getOpenid";

    }


    //2、获取token
    @RequestMapping(value = "/a/wx/token", method = RequestMethod.GET)
    public String getToken(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" get token info ");

        try {

            String token = weixinService.getToken(null, null);
            log.info(" get token result is " + token);

            model.addAttribute("code", 0);
            model.addAttribute("token", token);

        } catch (Throwable t) {
            log.error("get token error  ");
            t.printStackTrace();
        }
        return "/weixin/token/getWXToken";

    }

    //3、更新token
    @RequestMapping(value = "/a/wx/token", method = RequestMethod.PUT)
    public String updateToken(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" get token info ");

        try {

            weixinService.updateAccessToken();
            log.info(" update token success ");

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error("update token error");
            t.printStackTrace();
        }
        return "/common/success";

    }

    //4、获取签名
    @RequestMapping(value = "/a/wx/signature", method = RequestMethod.GET)
    public String updateToken(HttpServletRequest request, HttpServletResponse response, ModelMap model, String url) {
        log.info(" get signature info ");

        try {

//            Map e = sign(ticket, url);
//            log.info(e);
//            JSAPI jsapi = new JSAPI(WxConstantConfig.appid, (String)e.get("timestamp"), (String)e.get("nonceStr"), (String)e.get("signature"));

            JSAPI jsapi = weixinService.getJSAPI(null, null, url);
            log.info("url " + url + " get JSAPI success :" + jsapi);

            model.addAttribute("code", 0);
            model.addAttribute("jsapi", jsapi);

        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/weixin/jsapi/show";

    }


    //5、微信支付订单信息
    @RequestMapping(value = "/a/wx/pay/info/{oid}", method = RequestMethod.GET)
    public String getPayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) {
        log.info("order : " + oid + " get pay info ");

        XmlUtil xmlUtil = new XmlUtil();

        String name = "";

        try {
            log.info("==========检验是否拥有本订单==========");
            UserOrder order = userOrderService.getObjectById(oid);
            if (null == order) {
                log.info("already pay the order");
                model.addAttribute("code", -3007);
                return "/common/success";
            }

            Integer type = order.getBuyType();
            Long targetId = order.getTargetId();

            //购买目标是否存在
            if (UserOrder.ORDER_MEMBER == type)  {
                Member member = memberService.getObjectById(targetId);
                if (null == member) {
                    log.info("member not exist");
                    model.addAttribute("code", -6008);
                    return "/common/success";
                }else {
                    name = member.getName();
                }
            }
            log.info("order name : " + name);

            String nonce_str = getRandomStringByLength(16);
            String timestamp = create_timestamp();

            Long relation = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(order.getUid(), UserOpenidRelation.TYPE_WEIXIN);

            if (null == relation) {
                log.info("user have no weixin");
                model.addAttribute("code", -4042);
                return "/common/success";
            }

            UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(relation);

            String openid = userOpenidRelation.getOpenid();
            log.info("openid is " + openid);

            //调用微信预下单接口
            String perSign = "appid=" + WxConstantConfig.appid
                    + "&body=" + name
                    + "&mch_id=" + WxConstantConfig.mch_id
                    + "&nonce_str=" + nonce_str
//                    + "&notify_url=" + "http://www.studyingathome.cn/payResult"
                    + "&notify_url=" + "http://app.xuezhaleyuan.com/payResult"
                    + "&openid=" + openid
                    + "&out_trade_no=" + order.getOrderId()
                    + "&spbill_create_ip=" + "123.66.195.80"
                    + "&total_fee=" + order.getPrice().multiply(new BigDecimal(100)).intValue()
                    + "&trade_type=JSAPI"
                    + "&key=" + WxConstantConfig.js_key;

            log.info("perSign is : " + perSign);
            String sign = MD5.MD5Encode(perSign);
            sign = exChange(sign);
            log.info("sign is : " + sign);

            String url = "<xml>" +
                    "<appid>" + WxConstantConfig.appid + "</appid>" +
                    "<body>" + name + "</body>" +
                    "<mch_id>" + WxConstantConfig.mch_id + "</mch_id>" +
                    "<nonce_str>" + nonce_str + "</nonce_str>" +
//                    "<notify_url>" + "http://www.studyingathome.cn/payResult" + "</notify_url>" +
                    "<notify_url>" + "http://app.xuezhaleyuan.com/payResult" + "</notify_url>" +
                    "<openid>" + openid + "</openid>" +
                    "<out_trade_no>" + order.getOrderId() + "</out_trade_no>" +
                    "<spbill_create_ip>" + "123.66.195.80" + "</spbill_create_ip>" +
                    "<total_fee>" + order.getPrice().multiply(new BigDecimal(100)).intValue() + "</total_fee>" +
                    "<trade_type>JSAPI</trade_type>" +
                    "<sign>" + sign + "</sign>" +
                    "</xml>";
            log.info("url is : " + url);


            String httpsresponse = httpClientUtil.sendPostRequestByJava(WxConstantConfig.order_url, url);
            log.info("get order url result is " + httpsresponse);

            String prepay_id = xmlUtil.xml(httpsresponse);

            String perPaySign = "appId=" + WxConstantConfig.appid
                    + "&nonceStr=" + nonce_str
                    + "&package=prepay_id=" + prepay_id
                    + "&signType=" + "MD5"
                    + "&timeStamp=" + timestamp
                    + "&key=" + WxConstantConfig.js_key;

            log.info("perPaySign is : " + perPaySign);
            String paySign = MD5.MD5Encode(perPaySign);
            paySign = exChange(paySign);
            log.info("paySign is : " + paySign);

            model.addAttribute("code", 0);
            model.addAttribute("package", "prepay_id=" + prepay_id);
            model.addAttribute("nonceStr", nonce_str);
            model.addAttribute("signType", "MD5");
            model.addAttribute("timeStamp", timestamp);
            model.addAttribute("paySign", paySign);

        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/weixin/order/show";

    }

    //6、移动端微信支付订单信息
    @RequestMapping(value = "/a/wx/app/pay/info/{oid}", method = RequestMethod.GET)
    public String getAppPayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) {
        log.info("order : " + oid + " get app pay info ");

        XmlUtil xmlUtil = new XmlUtil();

        String name = "";

        try {
            log.info("==========检验是否拥有本订单==========");
            UserOrder order = userOrderService.getObjectById(oid);
            if (null == order) {
                log.info("already pay the order");
                model.addAttribute("code", -3007);
                return "/common/success";
            }

            Integer type = order.getBuyType();
            Long targetId = order.getTargetId();

            //购买目标是否存在
            if (UserOrder.ORDER_MEMBER == type) {
                Member member = memberService.getObjectById(targetId);
                if (null == member) {
                    log.info("member not exist");
                    model.addAttribute("code", -6008);
                    return "/common/success";
                }else {
                    name = member.getName();
                }
            }
            log.info("order name : " + name);

            String nonce_str = getRandomStringByLength(16);
            String timestamp = create_timestamp();

//            Long relation = userOpenidRelationService.getUserOpenidRelationIdByUidAndType(order.getUid(), UserOpenidRelation.TYPE_WEIXIN);
//
//            if (null == relation) {
//                log.info("user have no weixin");
//                model.addAttribute("code", -4042);
//                return "/common/success";
//            }

//            UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(relation);

//            String openid = userOpenidRelation.getOpenid();
//            log.info("openid is " + openid);

            //调用微信预下单接口
            String perSign = "appid=" + WxConstantConfig.open_appid
                    + "&body=" + name
                    + "&mch_id=" + WxConstantConfig.open_mch_id
                    + "&nonce_str=" + nonce_str
//                    + "&notify_url=" + "http://www.studyingathome.cn/payResult"
                    + "&notify_url=" + "http://app.xuezhaleyuan.com/payResult"
//                    + "&openid=" + openid
                    + "&out_trade_no=" + order.getOrderId()
                    + "&spbill_create_ip=" + "123.66.195.80"
                    + "&total_fee=" + order.getPrice().multiply(new BigDecimal(100)).intValue()
                    + "&trade_type=APP"
                    + "&key=" + WxConstantConfig.app_key;

            String sign = MD5.MD5Encode(perSign);
            sign = exChange(sign);
            log.info("sign is : " + sign);

            String url = "<xml>" +
                    "<appid>" + WxConstantConfig.open_appid + "</appid>" +
                    "<body>" + name + "</body>" +
                    "<mch_id>" + WxConstantConfig.open_mch_id + "</mch_id>" +
                    "<nonce_str>" + nonce_str + "</nonce_str>" +
//                    "<notify_url>" + "http://www.studyingathome.cn/payResult" + "</notify_url>" +
                    "<notify_url>" + "http://app.xuezhaleyuan.com/payResult" + "</notify_url>" +
//                    "<openid>" + openid + "</openid>" +
                    "<out_trade_no>" + order.getOrderId() + "</out_trade_no>" +
                    "<spbill_create_ip>" + "123.66.195.80" + "</spbill_create_ip>" +
                    "<total_fee>" + order.getPrice().multiply(new BigDecimal(100)).intValue() + "</total_fee>" +
                    "<trade_type>APP</trade_type>" +
                    "<sign>" + sign + "</sign>" +
                    "</xml>";
            log.info("url is : " + url);


            String httpsresponse = httpClientUtil.sendPostRequestByJava(WxConstantConfig.order_url, url);
            log.info("get order url result is " + httpsresponse);

            String prepay_id = xmlUtil.xml(httpsresponse);

            String perPaySign =
                    "appid=" + WxConstantConfig.open_appid
                    + "&noncestr=" + nonce_str
                    + "&package=Sign=WXPay"
                    + "&partnerid=" + WxConstantConfig.open_mch_id
                    + "&prepayid=" + prepay_id
                    + "&timestamp=" + timestamp
                    + "&key=" + WxConstantConfig.app_key;

            log.info("perPaySign is : " + perPaySign);

            String paySign = MD5.MD5Encode(perPaySign);
            paySign = exChange(paySign);
            log.info("pay sign is : " + paySign);

            model.addAttribute("code", 0);
            model.addAttribute("prepayid", prepay_id);
            model.addAttribute("nonceStr", nonce_str);
            model.addAttribute("timeStamp", timestamp);
            model.addAttribute("paySign", paySign);

        } catch (Throwable t) {
            log.error("get app order info error");
            t.printStackTrace();
        }
        return "/weixin/order/show";

    }

    //6、获取图片
    @RequestMapping(value = "/a/wx/media", method = RequestMethod.GET)
    public String getMedia(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mediaId) {
        log.info(" get image info by : " + mediaId);

        try {
            String url = this.saveImageToDisk(mediaId);

            model.addAttribute("code", 0);
            model.addAttribute("url", url);


        } catch (Throwable t) {
            log.error("get weixin img error");
            t.printStackTrace();
        }
        return "/common/img";

    }

    //脚本更新token
    @RequestMapping(value = "/a/update/accesstoken", method = RequestMethod.GET)
    public void updateAccessToken(HttpServletRequest request, ModelMap model, HttpServletResponse response,String password) throws Exception {
        log.info(" password is "+password);

        if(password.equals("academy2017")){
            this.weixinService.updateAccessToken();
            log.info("update success ");
        }else{
            log.info("not have right password");
        }

    }

    public static void main(String[] args) {
        String response3 = HttpClientUtil.sendGetRequest("https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=9Y5-kj5ett6YJaFLvPlsj9PENF-Hp0VurcMome4Czf4C5RWUQ0YyT0-lCRMLVAgwlfDe7zVULgncb28Aw-yw6-8bYATSB30bEAU8rd_DqH8_-3-NMdopIbqUVeceMmVlSMTjAGAKEL", null);
        System.out.println(response3);
    }


    public static String getRandomStringByLength(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String exChange(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); i++) {
                char c = str.charAt(i);
                if ('a' <= c && c <= 'z') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(c);
                }
            }
        }

        return sb.toString();
    }

    public static Map<String, String> sign(String jsapi_ticket, String url) {
        HashMap ret = new HashMap();
//        String nonce_str = create_nonce_str();
//        String timestamp = create_timestamp();
        String nonce_str = "2be53eec-927f-42a1-8dbf-c7730bf84b03";
        String timestamp = "1471244768";
        String signature = "";
        String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
        log.info("signString : " + string1);

        try {
            MessageDigest e = MessageDigest.getInstance("SHA-1");
            e.reset();
            e.update(string1.getBytes("UTF-8"));
            signature = byteToHex(e.digest());
        } catch (NoSuchAlgorithmException var8) {
            var8.printStackTrace();
        } catch (UnsupportedEncodingException var9) {
            var9.printStackTrace();
        }

        ret.put("url", url);
        ret.put("jsapi_ticket", jsapi_ticket);
        ret.put("nonceStr", nonce_str);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        return ret;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] result = hash;
        int len$ = hash.length;

        for (int i$ = 0; i$ < len$; ++i$) {
            byte b = result[i$];
            formatter.format("%02x", new Object[]{Byte.valueOf(b)});
        }

        String var6 = formatter.toString();
        formatter.close();
        return var6;
    }


    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    /**
     * 根据文件id下载文件
     *
     * @param mediaId 媒体id
     * @throws Exception
     */

    public InputStream getInputStream(String mediaId) {

        InputStream is = null;

        try {
            String accessToken = weixinService.getToken(null, null);
            log.info("accessToken : " + accessToken);

            String mediaUrl = ThreePartPropertiesUtil.getProperty("weixinMedia");
            log.info("media url : " + mediaUrl);
            mediaUrl = mediaUrl.replace("{token}", accessToken);
            mediaUrl = mediaUrl.replace("{mediaid}", mediaId);
            log.info("token url is " + mediaUrl);

            URL urlGet = new URL(mediaUrl);
            HttpURLConnection http = (HttpURLConnection) urlGet.openConnection();
            http.setRequestMethod("GET"); // 必须是get方式请求
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);

            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");// 连接超时30秒
            System.setProperty("sun.net.client.defaultReadTimeout", "30000"); // 读取超时30秒

            http.connect();

            // 获取文件转化为byte流
            is = http.getInputStream();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return is;

    }

    /**
     * 获取下载图片信息（jpg）
     *
     * @param mediaId 文件的id
     * @throws Exception
     */

    public String saveImageToDisk(String mediaId) throws Exception {

        String filePath = "";
        String fileName = "";
        String module = "weixin";

        log.info("save image by media id : " + mediaId);
        InputStream inputStream = getInputStream(mediaId);
        byte[] data = new byte[1024];
        int len = 0;
        FileOutputStream fileOutputStream = null;

        try {
            fileName = UUID.randomUUID().toString() + ".jpg";
            log.info("new name is " + fileName);
            filePath = "/data/temp/" + fileName;
            log.info("file path : " + filePath);
//            filePath = "C:\\Users\\asus\\Desktop\\" + fileName;
            fileOutputStream = new FileOutputStream(filePath);

            while ((len = inputStream.read(data)) != -1) {
                fileOutputStream.write(data, 0, len);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {

            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        File file = new File(filePath);
        if(file.exists()){
            log.info("file exist");
        }else {
            log.info("file not exist");
        }

        String url = this.imgStorageUtil.imgStorage(module, module + "/" + fileName, filePath);
        log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath + " access url is " + url);
        file.delete();
        log.info(file.getName() + " delete success ");

        return url;
    }
}
