package com.ptteng.academy.home.controller;

import com.ptteng.academy.document.model.Document;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.DocumentService;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.academy.home.util.DynamicUtil;
import com.ptteng.academy.user.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Document  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class DocumentController {
    private static final Log log = LogFactory.getLog(DocumentController.class);

    @Autowired
    private DocumentService documentService;

    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;


    /**
     * @param id 文档id
     * @Description 查看文档详情
     * @Author: PeiyuFeng
     * @Time 2017/3/15 17:16
     */
    @RequestMapping(value = "/a/u/document/{id}", method = RequestMethod.GET)
    public String getShareLessonJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        if (id == null) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        log.info("get uid " + uid);

        log.info("get document data : id= " + id);

        Boolean collectionStatus = false;
        Boolean likeStatus = false;

        try {

            Document document = documentService.getObjectById(id);

            if (document == null) {
                log.info("document don't exist");
                model.addAttribute("code", -2107);
                return "/common/success";
            }else {
                Integer readCount = document.getRead_count();
                document.setRead_count(readCount + 1);
                log.info("document " + id + " read count : " + readCount + " >>>>>>>>>> " + document.getRead_count());
                documentService.update(document);
            }

            //用户收藏状态
            Long collectionRelationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus
                    (id, uid, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_COLLECTION, UserFavoriteRelation.STATUS_ACTIVE);
            if(null == collectionRelationId){
                log.info("no collection relation");
            }else {
                log.info("collection relation id : " + id);
                collectionStatus = true;
            }
            //用户点赞状态
            Long likeRelationId = userFavoriteRelationService.getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus
                    (id, uid, UserFavoriteRelation.TARGET_TYPE_DOCUMENT, UserFavoriteRelation.TYPE_LIKE, UserFavoriteRelation.STATUS_ACTIVE);
            if(null == likeRelationId){
                log.info("no like relation");
            }else {
                log.info("like relation id : " + id);
                likeStatus = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("document", document);
            model.addAttribute("collectionStatus", collectionStatus);
            model.addAttribute("likeStatus", likeStatus);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentDetailJson";
    }

    /**
     * @Description 根据类型与文档名查询文档列表
     * @param type 文档类型banner/normal
     * @param title 文档标题
     * @Author: PeiyuFeng
     * @Time 2017/3/15 17:42
     */
    @RequestMapping(value = "/a/u/document/list", method = RequestMethod.GET)
    public String getDocumentList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                  Integer page, Integer size, Integer type, String title) throws Exception {

        log.info("get document list type is" + type + " title is " + title);

        List<Long> documentIds = new ArrayList<>();
        List<Long> count = new ArrayList<>();

        Integer total = null;
        if (page == null) {
            page = 1;
        }
        if (size == null || size == 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);
        User user = (User) request.getAttribute("user");
        Long uid = user.getId();
        try {
            Map<String, Object> param = DynamicUtil.getDocumentList(type, title);
            log.info("param is " + param);
            documentIds = documentService.getIdsByDynamicCondition(Document.class, param, start, size);
            count = documentService.getIdsByDynamicCondition(Document.class, param, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("total size " + total);

            if (documentIds != null && documentIds.size() > 0) {

                log.info("get article list ids is" + documentIds);
                List<Document> documentList = documentService.getObjectsByIds(documentIds);
                model.addAttribute("documentList", documentList);
            }

            Boolean next = false;
            Integer nex = start + size;

            if (total > nex) {
                next = true;
            }

            Integer totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);
            model.addAttribute("next", next);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get document list error,page is  " + start + " , size " + size);

            model.addAttribute("code", -1);
        }

        return "/academy-document-service/document/json/documentListJson";
    }






}

