/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.finance.etl;

import com.ptteng.academy.user.model.Invitation;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.service.InvitationService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ConsignPayEtl {
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 30000L;
    private static final Log log = LogFactory.getLog((String)"autoScan");
    private UserService userService;
    private InvitationService invitationService;
    private UserMemberRelationService userMemberRelationService;
    private Long interval = 30000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    List<UserMemberRelation> userMemberRelations = this.getUserMemberRelation();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("@table", "user u,user_openid_relation uor");
                    map.put("u.invitation_code & is", " null");
                    map.put("uor.type & not in ", "('school','tengxunzhihuixiaoyuan','xinhuameiyu','xinhuameiyuR')");
                    map.put("uor.uid ", "u.id");
                    map.put("@group", "uor.uid");
                    map.put("@query", "u.id");
                    List ids = this.userService.getIdsByDynamicCondition(User.class, map, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                    log.info((Object)("ids size is " + ids.size()));
                    if (ids.size() > 0) {
                        List codes = this.invitationService.getNewInvitations(Integer.valueOf(ids.size()));
                        log.info((Object)("codes size " + codes.size()));
                        List invitationList = this.invitationService.getObjectsByIds(codes);
                        List userList = this.userService.getObjectsByIds(ids);
                        int i = 0;
                        for (User user : userList) {
                            if (DataUtils.isNullOrEmpty((Object)user.getInvitationCode())) {
                                Invitation invitation = (Invitation)invitationList.get(i);
                                user.setInvitationCode(invitation.getId().toString());
                                invitation.setStatus(Invitation.DISABLE);
                                invitation.setUid(user.getId());
                            }
                            ++i;
                        }
                        this.userService.updateList(userList);
                        log.info((Object)"user list update success");
                        this.invitationService.updateList(invitationList);
                        log.info((Object)"user list update success");
                    }
                    if (!CollectionUtils.isEmpty(userMemberRelations)) continue;
                    log.info((Object)"userMemberRelations etl not get any id ,sleep 30000 ms ");
                    Thread.sleep(30000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.info((Object)t.getMessage(), t);
                Thread.sleep(30000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<UserMemberRelation> getUserMemberRelation() {
        List<Object> userMemberRelations = new ArrayList<UserMemberRelation>();
        Long now = System.currentTimeMillis();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(" status ", 1);
        param.put(" end_at & <=", now);
        param.put("@table", " user_member_relation");
        try {
            List ids = this.userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isEmpty((Collection)ids)) {
                log.info((Object)"not ger any process message ");
            } else {
                userMemberRelations = this.userMemberRelationService.getObjectsByIds(ids);
                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                    if (now < userMemberRelation.getEndAt()) continue;
                    log.info((Object)(" userMemberRelation id = " + userMemberRelation.getId()));
                    userMemberRelation.setStatus(Integer.valueOf(0));
                }
                this.userMemberRelationService.updateList(userMemberRelations);
                log.info((Object)("get process messages is " + userMemberRelations.size()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage(), t);
        }
        return userMemberRelations;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public UserMemberRelationService getUserMemberRelationService() {
        return this.userMemberRelationService;
    }

    public void setUserMemberRelationService(UserMemberRelationService userMemberRelationService) {
        this.userMemberRelationService = userMemberRelationService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public InvitationService getInvitationService() {
        return this.invitationService;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public static void main(String[] arg) {
    }
}

