/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.finance.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.model.Article;
import com.ptteng.academy.admin.service.ArticleService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ArticleEtl {
    private static final Log log = LogFactory.getLog(ArticleEtl.class);
    private ArticleService articleService;

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public void changeSort() throws ServiceException, ServiceDaoException {
        try {
            log.info((Object)"article:start chang sort ");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(" type", Article.advertising);
            param.put("@order", "  orderBy asc , create_at desc ");
            param.put("@query", " id ");
            param.put("@table", "article");
            List articleIds = this.articleService.getIdsByDynamicCondition(Article.class, param, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            List articles = this.articleService.getObjectsByIds(articleIds);
            for (int i = 0; i < articleIds.size(); ++i) {
                Article article = (Article)articles.get(i);
                if (i == 0) {
                    article.setStatus(Article.Status_Unpublished);
                    article.setOrderBy(Integer.valueOf(this.getMaxSort(article.getType()) - 10));
                    continue;
                }
                if (i == 1) {
                    article.setStatus(Article.Status_Published);
                }
                article.setOrderBy(Integer.valueOf(article.getOrderBy() - 10));
            }
            this.articleService.updateList(articles);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.info((Object)t.getMessage(), t);
        }
    }

    private Integer getMaxSort(Integer type) throws ServiceException, ServiceDaoException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(" type", type);
            param.put("@order", "  orderBy asc , create_at desc ");
            param.put("@query", " id ");
            param.put("@table", "article");
            List articleIds = this.articleService.getIdsByDynamicCondition(Article.class, param, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
            Integer max = 0;
            if (CollectionUtils.isEmpty((Collection)articleIds)) {
                log.info((Object)"first order ");
            } else {
                Long maxID = (Long)articleIds.get(articleIds.size() - 1);
                log.info((Object)(" maxID = " + maxID));
                max = this.articleService.getObjectById(maxID).getOrderBy();
                if (null == max) {
                    max = 0;
                }
                log.info((Object)("quiz max order is " + max));
            }
            return max + 10;
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.info((Object)t.getMessage(), t);
            return 0;
        }
    }
}

