package com.ptteng.academy.finance.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.model.Article;
import com.ptteng.academy.admin.service.ArticleService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Master
 * @date 2018/4/14
 */
@Component
public class ArticleEtl {
    private static final Log log = LogFactory.getLog(ArticleEtl.class);

    private ArticleService articleService;
    public ArticleService getArticleService() {
        return articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public void changeSort() throws ServiceException, ServiceDaoException {
        try{
            log.info("article:start chang sort ");
            Map<String, Object> param = new HashMap<>();
            param.put(" type", Article.advertising);
            param.put("@order", "  orderBy asc , create_at desc ");
            param.put("@query", " id ");
            param.put("@table", "article");
            List<Long> articleIds = this.articleService.getIdsByDynamicCondition(Article.class, param, 0, Integer.MAX_VALUE);
            List<Article> articles = articleService.getObjectsByIds(articleIds);

            // 设置下架
            for (int i = 0; i < articleIds.size(); i++) {

                Article article = articles.get(i);
                if (i == 0) {
                    article.setStatus(Article.Status_Unpublished);
                    article.setOrderBy(getMaxSort(article.getType())-10);
                    continue;
                }

                if (i == 1) {
                    article.setStatus(Article.Status_Published);
                }
                article.setOrderBy(article.getOrderBy() - 10);

            }
            articleService.updateList(articles);
        }catch (Throwable t) {
            t.printStackTrace();
            log.info(t.getMessage(), t);
        }

    }
    private Integer getMaxSort(Integer type) throws ServiceException, ServiceDaoException {

        try {
            Map<String, Object> param = new HashMap<>();
            param.put(" type",type);
            param.put("@order", "  orderBy asc , create_at desc ");
            param.put("@query", " id ");
            param.put("@table", "article");
            List<Long> articleIds = this.articleService.getIdsByDynamicCondition(
                    Article.class, param, 0, Integer.MAX_VALUE);
            Integer max = 0;
            if (CollectionUtils.isEmpty(articleIds)) {
                log.info("first order ");

            } else {
                Long maxID = articleIds.get(articleIds.size() - 1);
                log.info(" maxID = " + maxID);
                max = this.articleService.getObjectById(maxID).getOrderBy();
                if (null == max) {
                    max = 0;
                }
                log.info("quiz max order is " + max);
            }
            return max + 10;
        }catch (Throwable t) {
            t.printStackTrace();
            log.info(t.getMessage(), t);
            return 0;
        }

    }
}
