package com.ptteng.academy.finance.etl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gemantic.common.util.StringUtil;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.common.util.notice.NoticeUtil;
//import com.ptteng.academy.common.model.Message;
import com.ptteng.academy.user.service.UserMemberRelationService;
//import com.ptteng.academy.common.service.MessageService;
import com.ptteng.academy.common.service.UserMessageRelationService;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.service.UserService;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ConsignPayEtl {

	private static final int TASK_LEN = 100;// 一次任务检测的条数

	private static final long SLEEP_MILLISECOND = 30000;// ====空转任务间隔休息毫秒数

	private static final Log log = LogFactory.getLog("autoScan");


    private UserService userService;
    private UserMemberRelationService userMemberRelationService;
    private Long interval=30000L;


	public ConsignPayEtl() {
		super();
	}

	public void process() throws InterruptedException {

		while (true) {

			try {
			List<UserMemberRelation> userMemberRelations = getUserMemberRelation();
				if(CollectionUtils.isEmpty(userMemberRelations)){
					log.info("userMemberRelations etl not get any id ,sleep "+SLEEP_MILLISECOND+" ms ");
					Thread.sleep(SLEEP_MILLISECOND);

				}





			} catch (Throwable t) {

				t.printStackTrace();
				Thread.sleep(SLEEP_MILLISECOND);
				log.error("process goods bytime status error ,sleep " + t.getMessage());
			}

		}

	}

	private List<UserMemberRelation> getUserMemberRelation() {
		List<UserMemberRelation> userMemberRelations = new ArrayList<>();
		Long now = System.currentTimeMillis();
		Map<String,Object> param = new HashMap<>();
		//会员状态订单
		param.put(" status ", User.IS_MEMBER);
		param.put(" end_at & <=", now);
		param.put("@table"," user_member_relation");


		try {
			List<Long> ids = this.userMemberRelationService.getIdsByDynamicCondition(UserMemberRelation.class, param, 0, TASK_LEN);
			if(CollectionUtils.isEmpty(ids)){

				log.info("not ger any process message ");
			}else{
				userMemberRelations=this.userMemberRelationService.getObjectsByIds(ids);
				for(UserMemberRelation userMemberRelation : userMemberRelations){
					if(now>=userMemberRelation.getEndAt()){
						log.info(" userMemberRelation id = "+userMemberRelation.getId());
						userMemberRelation.setStatus(User.IS_EXPRIED_MEMBER);

					}
				}
				this.userMemberRelationService.updateList(userMemberRelations);

				log.info("get process messages is "+userMemberRelations.size());
			}

		} catch (Throwable t) {
			// TODO Auto-generated catch block
			t.printStackTrace();
			log.error(t);
		}
		return userMemberRelations;
	}




    public void setUserService(UserService userService) {
        this.userService = userService;
    }
	public UserService getUserService() {
		return userService;
	}
    public UserMemberRelationService getUserMemberRelationService() {
        return userMemberRelationService;
    }

    public void setUserMemberRelationService(UserMemberRelationService userMemberRelationService) {
        this.userMemberRelationService = userMemberRelationService;
    }

    public Long getInterval() {
		return interval;
	}

	public void setInterval(Long interval) {
		this.interval = interval;
	}





	public static void main(String [] arg){

	}







}
