-- ----------------------------
-- Table structure for `document`
-- ----------------------------
-- DROP TABLE IF EXISTS `document`;
CREATE TABLE `document` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `title` text    COMMENT '文章标题',  
    `type` int    COMMENT '文章类型',  
    `img` varchar(255)    COMMENT '文章图片',  
    `order_by` varchar(255)    COMMENT '排序字段',  
    `author` varchar(100)    COMMENT '作者',  
    `source` varchar(500)    COMMENT '来源',  
    `content` varchar(100)    COMMENT '内容',  
    `summary` text    COMMENT '摘要',  
    `publish_at` bigint    COMMENT '发布时间',  
    `status` tinyint NOT NULL   COMMENT '发布状态',  
    `url` varchar(200)    COMMENT '外链地址',  
    `read_count` int NOT NULL   COMMENT '浏览数',  
    `publish_type` int    COMMENT '发布类型',  
    `love` bigint NOT NULL   COMMENT '点赞数',  
    `collection` bigint NOT NULL   COMMENT '收藏数',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `teacher`
-- ----------------------------
-- DROP TABLE IF EXISTS `teacher`;
CREATE TABLE `teacher` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` bigint NOT NULL   COMMENT '职业种类ID',  
    `profile_photo` bigint NOT NULL   COMMENT '职业ID',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `video`
-- ----------------------------
-- DROP TABLE IF EXISTS `video`;
CREATE TABLE `video` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `grade` int NOT NULL   COMMENT '年级',  
    `subject` int NOT NULL   COMMENT '科目',  
    `teacher_name` varchar(20)    COMMENT '教师名称',  
    `teacher_img` varchar(200)    COMMENT '教师头像',  
    `title` text NOT NULL   COMMENT '视频标题',  
    `type` int NOT NULL   COMMENT '视频类型（banner/card）',  
    `cover_img` varchar(255)    COMMENT '视频封面图片',  
    `cut_img` varchar(255)    COMMENT '视频截图图片',  
    `order_by` int    COMMENT '排序字段',  
    `source` varchar(500)    COMMENT '来源',  
    `content` text    COMMENT '内容',  
    `summary` text    COMMENT '摘要',  
    `publish_at` bigint    COMMENT '发布时间',  
    `status` tinyint NOT NULL   COMMENT '发布状态',  
    `url` varchar(500)    COMMENT '外链地址',  
    `read_count` int NOT NULL   COMMENT '浏览数',  
    `publish_type` int    COMMENT '发布类型',  
    `love` bigint NOT NULL   COMMENT '点赞数',  
    `collection` bigint NOT NULL   COMMENT '收藏数',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_favorite_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_favorite_relation`;
CREATE TABLE `user_favorite_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `target_id` bigint NOT NULL   COMMENT '目标id',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `status` int NOT NULL   COMMENT '收藏/取消收藏',  
    `target_type` int NOT NULL   COMMENT '目标类型（文档/视频）',  
    `type` int NOT NULL   COMMENT '类型（点赞/收藏）',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for `video_grade_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `video_grade_relation`;
CREATE TABLE `video_grade_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `video_id` bigint NOT NULL   COMMENT '视频ID',
    `grade` int(11) NOT NULL   COMMENT '年级',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


