/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Video;
import com.ptteng.academy.document.service.VideoService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VideoServiceImpl
extends BaseDaoServiceImpl
implements VideoService {
    private static final Log log = LogFactory.getLog(VideoServiceImpl.class);

    public Long insert(Video video) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + video));
        if (video == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        video.setCreateAt(Long.valueOf(currentTimeMillis));
        video.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)video);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + video));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Video> insertList(List<Video> videoList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (videoList == null ? "null" : Integer.valueOf(videoList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(videoList)) {
            return new ArrayList<Video>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Video video : videoList) {
            video.setCreateAt(Long.valueOf(currentTimeMillis));
            video.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(videoList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + videoList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Video.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Video video) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (video == null ? "null" : video.getId())));
        boolean result = false;
        if (video == null) {
            return true;
        }
        video.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)video);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + video));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + video));
        }
        return result;
    }

    public boolean updateList(List<Video> videoList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (videoList == null ? "null" : Integer.valueOf(videoList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(videoList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Video video : videoList) {
            video.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(videoList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + videoList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + videoList.size()));
        return result;
    }

    public Video getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Video video = null;
        if (id == null) {
            return video;
        }
        try {
            video = (Video)this.dao.get(Video.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return video;
    }

    public List<Video> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List video = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Video>();
        }
        try {
            video = this.dao.getList(Video.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (video == null ? "null" : Integer.valueOf(video.size()))));
        return video;
    }

    public List<Long> getVideoIdsByGradeAndSubjectAndTypeAndStatusOrderByUpdateAt(Integer grade, Integer subject, Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by grade,subject,type,status,start,limit  : " + grade + " , " + subject + " , " + type + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVideoIdsByGradeAndSubjectAndTypeAndStatusOrderByUpdateAt", new Object[]{grade, subject, type, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by grade,subject,type,status,start,limit)  : " + grade + " , " + subject + " , " + type + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countVideoIdsByGradeAndSubjectAndTypeAndStatusOrderByUpdateAt(Integer grade, Integer subject, Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by grade,subject,type,status  : " + grade + " , " + subject + " , " + type + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getVideoIdsByGradeAndSubjectAndTypeAndStatusOrderByUpdateAt", new Object[]{grade, subject, type, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by grade,subject,type,status)  : " + grade + " , " + subject + " , " + type + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getVideoIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getVideoIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countVideoIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getVideoIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getVideoIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

