package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Reply;
import com.ptteng.academy.document.service.ReplyService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ReplyServiceImpl extends BaseDaoServiceImpl implements ReplyService {


    private static final Log log = LogFactory.getLog(ReplyServiceImpl.class);


    @Override
    public Long insert(Reply reply) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + reply);

        if (reply == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        reply.setCreateAt(currentTimeMillis);
        reply.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(reply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + reply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Reply> insertList(List<Reply> replyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (replyList == null ? "null" : replyList.size()));

        List<Reply> resultList = null;

        if (CollectionUtils.isEmpty(replyList)) {
            return new ArrayList<Reply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Reply reply : replyList) {
            reply.setCreateAt(currentTimeMillis);
            reply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Reply>) dao.batchSave(replyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + replyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Reply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Reply reply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (reply == null ? "null" : reply.getId()));

        boolean result = false;

        if (reply == null) {
            return true;
        }

        reply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(reply);
        } catch (DaoException e) {
            log.error(" update wrong : " + reply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + reply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Reply> replyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (replyList == null ? "null" : replyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(replyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Reply reply : replyList) {
            reply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(replyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + replyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + replyList.size());

        return result;
    }


    @Override
    public Reply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Reply reply = null;

        if (id == null) {
            return reply;
        }

        try {
            reply = (Reply) dao.get(Reply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return reply;
    }


    @Override
    public List<Reply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Reply> reply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Reply>();
        }

        try {
            reply = (List<Reply>) dao.getList(Reply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (reply == null ? "null" : reply.size()));

        return reply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getReplyIdsByPidOrderByFloor(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by pid,start,limit  : " + pid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getReplyIdsByPidOrderByFloor", new Object[]{pid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by pid,start,limit)  : " + pid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getReplyIdsByPidOrderByFloorDesc(Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by pid,start,limit  : " + pid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getReplyIdsByPidOrderByFloorDesc", new Object[]{pid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by pid,start,limit)  : " + pid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countReplyIdsByPidOrderByFloor(Long pid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by pid  : " + pid);
        }
        Integer count = null;


        try {

            count = dao.count("getReplyIdsByPidOrderByFloor", new Object[]{pid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by pid)  : " + pid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getReplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getReplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countReplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getReplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getReplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

