/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.service.PostsService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PostsServiceImpl
extends BaseDaoServiceImpl
implements PostsService {
    private static final Log log = LogFactory.getLog(PostsServiceImpl.class);

    public Long insert(Posts posts) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + posts));
        if (posts == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        posts.setCreateAt(Long.valueOf(currentTimeMillis));
        posts.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)posts);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + posts));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Posts> insertList(List<Posts> postsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (postsList == null ? "null" : Integer.valueOf(postsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(postsList)) {
            return new ArrayList<Posts>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Posts posts : postsList) {
            posts.setCreateAt(Long.valueOf(currentTimeMillis));
            posts.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(postsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + postsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Posts.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Posts posts) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (posts == null ? "null" : posts.getId())));
        boolean result = false;
        if (posts == null) {
            return true;
        }
        posts.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)posts);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + posts));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + posts));
        }
        return result;
    }

    public boolean updateList(List<Posts> postsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (postsList == null ? "null" : Integer.valueOf(postsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(postsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Posts posts : postsList) {
            posts.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(postsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + postsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + postsList.size()));
        return result;
    }

    public Posts getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Posts posts = null;
        if (id == null) {
            return posts;
        }
        try {
            posts = (Posts)this.dao.get(Posts.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return posts;
    }

    public List<Posts> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List posts = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Posts>();
        }
        try {
            posts = this.dao.getList(Posts.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (posts == null ? "null" : Integer.valueOf(posts.size()))));
        return posts;
    }

    public List<Long> getDigestPostsIdsByGradeOrderByDigestAt(Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by grade,sticky,digest,start,limit  : " + grade + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getDigestPostsIdsByGradeOrderByDigestAt", new Object[]{grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by gradestart,limit)  : " + grade + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getNormalPostsIdsByGradeOrderByCreateAt(Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by grade,start,limit  : " + grade + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getNormalPostsIdsByGradeOrderByCreateAt", new Object[]{grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by grade,start,limit)  : " + grade + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStickyPostsIdsByGradeOrderByStickyAt(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by grade,sticky,start,limit  : " + grade));
        }
        List idList = null;
        try {
            idList = this.dao.getIdList("getStickyPostsIdsByGradeOrderByStickyAt", new Object[]{grade}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by grade,sticky,start,limit)  : " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPostsIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPostsIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPostsIdsByGrade(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)" count ids by grade ");
        }
        Integer count = null;
        try {
            count = this.dao.count("getPostsIdsByGradeOrderByCreateAt", new Object[]{grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by grade : " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countDigestPostsIdsByGradeOrderByDigestAt(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by grade : " + grade));
        }
        Integer count = null;
        try {
            count = this.dao.count("getDigestPostsIdsByGradeOrderByDigestAt", new Object[]{grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by grade,sticky,digest)  : " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countNormalPostsIdsByGradeOrderByCreateAt(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by grade  : " + grade));
        }
        Integer count = null;
        try {
            count = this.dao.count("getNormalPostsIdsByGradeOrderByCreateAt", new Object[]{grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by grade : " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countPostsIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getPostsIdsByUidOrderByCreateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getPostsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPostsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPostsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPostsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPostsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

