package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserFavoriteRelationServiceImpl extends BaseDaoServiceImpl implements UserFavoriteRelationService {


    private static final Log log = LogFactory.getLog(UserFavoriteRelationServiceImpl.class);


    @Override
    public Long insert(UserFavoriteRelation userFavoriteRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userFavoriteRelation);

        if (userFavoriteRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userFavoriteRelation.setCreateAt(currentTimeMillis);
        userFavoriteRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userFavoriteRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userFavoriteRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserFavoriteRelation> insertList(List<UserFavoriteRelation> userFavoriteRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userFavoriteRelationList == null ? "null" : userFavoriteRelationList.size()));

        List<UserFavoriteRelation> resultList = null;

        if (CollectionUtils.isEmpty(userFavoriteRelationList)) {
            return new ArrayList<UserFavoriteRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelationList) {
            userFavoriteRelation.setCreateAt(currentTimeMillis);
            userFavoriteRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserFavoriteRelation>) dao.batchSave(userFavoriteRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userFavoriteRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserFavoriteRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserFavoriteRelation userFavoriteRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userFavoriteRelation == null ? "null" : userFavoriteRelation.getId()));

        boolean result = false;

        if (userFavoriteRelation == null) {
            return true;
        }

        userFavoriteRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userFavoriteRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userFavoriteRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userFavoriteRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserFavoriteRelation> userFavoriteRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userFavoriteRelationList == null ? "null" : userFavoriteRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userFavoriteRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserFavoriteRelation userFavoriteRelation : userFavoriteRelationList) {
            userFavoriteRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userFavoriteRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userFavoriteRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userFavoriteRelationList.size());

        return result;
    }


    @Override
    public UserFavoriteRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserFavoriteRelation userFavoriteRelation = null;

        if (id == null) {
            return userFavoriteRelation;
        }

        try {
            userFavoriteRelation = (UserFavoriteRelation) dao.get(UserFavoriteRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userFavoriteRelation;
    }


    @Override
    public List<UserFavoriteRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserFavoriteRelation> userFavoriteRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserFavoriteRelation>();
        }

        try {
            userFavoriteRelation = (List<UserFavoriteRelation>) dao.getList(UserFavoriteRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userFavoriteRelation == null ? "null" : userFavoriteRelation.size()));

        return userFavoriteRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(Long targetId, Long uid, Integer targetType, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by targetId,uid,targetType,type  : " + targetId + " , " + uid + " , " + targetType + " , " + type);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType", new Object[]{targetId, uid, targetType, type});
        } catch (DaoException e) {
            log.error(" get id wrong by targetId,uid,targetType,type  : " + targetId + " , " + uid + " , " + targetType + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }

    @Override
    public Long getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus(Long targetId, Long uid, Integer targetType, Integer type, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by targetId,uid,targetType,type,status  : " + targetId + " , " + uid + " , " + targetType + " , " + type + " , " + status);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus", new Object[]{targetId, uid, targetType, type, status});
        } catch (DaoException e) {
            log.error(" get id wrong by targetId,uid,targetType,type,status  : " + targetId + " , " + uid + " , " + targetType + " , " + type + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus(Long uid, Integer targetType, Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,targetType,type,status : " + uid + " , " + targetType + " , " + type + " , " + status);
        }
        List<Long> ids = null;

        // TODO 参数检查!

        try {


            ids = dao.getIdList("getUserFavoriteRelationIdsByUidAndTargetTypeAndTypeAndStatus", new Object[]{uid, targetType, type, status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by uid,targetType,type,status : " + uid + " , " + targetType + " , " + type + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;
    }


    @Override
    public List<Long> getUserFavoriteRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserFavoriteRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserFavoriteRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserFavoriteRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserFavoriteRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getUserFavoriteRelationIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserFavoriteRelationIdsByUserIDAndType", new Object[]{userID, type}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

}

