package com.ptteng.academy.document.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.service.PostsService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class PostsServiceImpl extends BaseDaoServiceImpl implements PostsService {


    private static final Log log = LogFactory.getLog(PostsServiceImpl.class);


    @Override
    public Long insert(Posts posts) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + posts);

        if (posts == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        posts.setCreateAt(currentTimeMillis);
        posts.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(posts);
        } catch (DaoException e) {
            log.error(" insert wrong : " + posts);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Posts> insertList(List<Posts> postsList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (postsList == null ? "null" : postsList.size()));

        List<Posts> resultList = null;

        if (CollectionUtils.isEmpty(postsList)) {
            return new ArrayList<Posts>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Posts posts : postsList) {
            posts.setCreateAt(currentTimeMillis);
            posts.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Posts>) dao.batchSave(postsList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + postsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Posts.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Posts posts) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (posts == null ? "null" : posts.getId()));

        boolean result = false;

        if (posts == null) {
            return true;
        }

        posts.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(posts);
        } catch (DaoException e) {
            log.error(" update wrong : " + posts);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + posts);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Posts> postsList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (postsList == null ? "null" : postsList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(postsList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Posts posts : postsList) {
            posts.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(postsList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + postsList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + postsList.size());

        return result;
    }


    @Override
    public Posts getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Posts posts = null;

        if (id == null) {
            return posts;
        }

        try {
            posts = (Posts) dao.get(Posts.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return posts;
    }


    @Override
    public List<Posts> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Posts> posts = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Posts>();
        }

        try {
            posts = (List<Posts>) dao.getList(Posts.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (posts == null ? "null" : posts.size()));

        return posts;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDigestPostsIdsByGradeOrderByDigestAt(Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by grade,sticky,digest,start,limit  : " + grade + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDigestPostsIdsByGradeOrderByDigestAt", new Object[]{grade}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by gradestart,limit)  : " + grade + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getNormalPostsIdsByGradeOrderByCreateAt(Integer grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by grade,start,limit  : " + grade + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getNormalPostsIdsByGradeOrderByCreateAt", new Object[]{grade}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by grade,start,limit)  : " + grade + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getStickyPostsIdsByGradeOrderByStickyAt(Integer grade) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by grade,sticky,start,limit  : " + grade);
        }
        List<Long> idList = null;

        try {
            idList = dao.getIdList("getStickyPostsIdsByGradeOrderByStickyAt", new Object[]{grade}, 0, Integer.MAX_VALUE, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by grade,sticky,start,limit)  : " + grade);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getPostsIdsByUidOrderByCreateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPostsIdsByUidOrderByCreateAt", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Integer countPostsIdsByGrade(Integer grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" count ids by grade ");
        }
        Integer count = null;

        try {

            count = dao.count("getPostsIdsByGradeOrderByCreateAt", new Object[]{grade});


        } catch (DaoException e) {
            log.error(" count ids  wrong by grade : " + grade);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDigestPostsIdsByGradeOrderByDigestAt(Integer grade) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by grade : " + grade);
        }
        Integer count = null;


        try {

            count = dao.count("getDigestPostsIdsByGradeOrderByDigestAt", new Object[]{grade});


        } catch (DaoException e) {
            log.error(" count ids  wrong by grade,sticky,digest)  : " + grade);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countNormalPostsIdsByGradeOrderByCreateAt(Integer grade) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by grade  : " + grade);
        }
        Integer count = null;


        try {

            count = dao.count("getNormalPostsIdsByGradeOrderByCreateAt", new Object[]{grade});


        } catch (DaoException e) {
            log.error(" count ids  wrong by grade : " + grade);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countPostsIdsByUidOrderByCreateAt(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getPostsIdsByUidOrderByCreateAt", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getPostsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPostsIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countPostsIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getPostsIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getPostsIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

