/**
 * 
 */
package com.ptteng.sca.academy.document.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Posts;
import com.ptteng.academy.document.service.PostsService;

import java.util.List;
import java.util.Map;

public class PostsSCAClient implements PostsService {

    private PostsService postsService;

	public PostsService getPostsService() {
		return postsService;
	}
	
	
	public void setPostsService(PostsService postsService) {
		this.postsService =postsService;
	}
	
	
			   
		@Override
		public Long insert(Posts posts)throws ServiceException, ServiceDaoException{
		
		return postsService.insert(posts);
		          
		
		}	
		  
    	   
		@Override
		public List<Posts> insertList(List<Posts> postsList)throws ServiceException, ServiceDaoException{
		
		return postsService.insertList(postsList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return postsService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Posts posts)throws ServiceException, ServiceDaoException{
		
		return postsService.update(posts);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Posts> postsList)throws ServiceException, ServiceDaoException{
		
		return postsService.updateList(postsList);
		          
		
		}	
		  
    	   
		@Override
		public Posts getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return postsService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Posts> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return postsService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getDigestPostsIdsByGradeOrderByDigestAt(Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return postsService.getDigestPostsIdsByGradeOrderByDigestAt(grade,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getNormalPostsIdsByGradeOrderByCreateAt(Integer grade,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return postsService.getNormalPostsIdsByGradeOrderByCreateAt(grade,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStickyPostsIdsByGradeOrderByStickyAt(Integer grade)throws ServiceException, ServiceDaoException{
		
		return postsService.getStickyPostsIdsByGradeOrderByStickyAt(grade);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPostsIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return postsService.getPostsIdsByUidOrderByCreateAt(uid,start,limit);
	
	
	}

	@Override
	public Integer countPostsIdsByGrade(Integer grade) throws ServiceException, ServiceDaoException {
		return postsService.countPostsIdsByGrade(grade);
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countDigestPostsIdsByGradeOrderByDigestAt(Integer grade)throws ServiceException, ServiceDaoException{
		
		return postsService.countDigestPostsIdsByGradeOrderByDigestAt(grade);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countNormalPostsIdsByGradeOrderByCreateAt(Integer grade)throws ServiceException, ServiceDaoException{
		
		return postsService.countNormalPostsIdsByGradeOrderByCreateAt(grade);
	
	
	}

	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPostsIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		return postsService.countPostsIdsByUidOrderByCreateAt(uid);
	
	
	}
	
		
	
		@Override
	public List<Long> getPostsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return postsService.getPostsIds(start, limit);
	}

	@Override
	public Integer countPostsIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return postsService.countPostsIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return postsService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return postsService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   postsService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.postsService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

