package com.ptteng.academy.document.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface UserFavoriteRelationService extends BaseDaoService {


    public Long insert(UserFavoriteRelation userFavoriteRelation) throws ServiceException, ServiceDaoException;


    public List<UserFavoriteRelation> insertList(List<UserFavoriteRelation> userFavoriteRelationList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(UserFavoriteRelation userFavoriteRelation) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<UserFavoriteRelation> userFavoriteRelationList) throws ServiceException, ServiceDaoException;


    public UserFavoriteRelation getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<UserFavoriteRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndType(Long targetId, Long uid, Integer targetType, Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserFavoriteRelationIdByTargetIdAndUidAndTargetTypeAndTypeAndStatus(Long targetId, Long uid, Integer targetType, Integer type, Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserFavoriteRelationIdByUidAndTargetTypeAndTypeAndStatus(Long uid, Integer targetType, Integer type, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserFavoriteRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserFavoriteRelationIds() throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserFavoriteRelationIdsByUserIDAndType(Long userID, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;



}

