package com.ptteng.academy.document.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.document.model.Document;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DocumentService extends BaseDaoService {

	



   		   
		
		public Long insert(Document document)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Document> insertList(List<Document> documentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Document document)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Document> documentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Document getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Document> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status, Integer type)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getDocumentIdsByStatusAndTypeOrderByUpdateAt(Integer status, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getDocumentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countDocumentIds() throws ServiceException, ServiceDaoException;
	

}

