package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.UserUnitRelation;
import com.ptteng.academy.course.service.UserUnitRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserUnitRelationServiceImpl extends BaseDaoServiceImpl implements UserUnitRelationService {


    private static final Log log = LogFactory.getLog(UserUnitRelationServiceImpl.class);


    @Override
    public Long insert(UserUnitRelation userUnitRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userUnitRelation);

        if (userUnitRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userUnitRelation.setCreateAt(currentTimeMillis);
        userUnitRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userUnitRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userUnitRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserUnitRelation> insertList(List<UserUnitRelation> userUnitRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userUnitRelationList == null ? "null" : userUnitRelationList.size()));

        List<UserUnitRelation> resultList = null;

        if (CollectionUtils.isEmpty(userUnitRelationList)) {
            return new ArrayList<UserUnitRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserUnitRelation userUnitRelation : userUnitRelationList) {
            userUnitRelation.setCreateAt(currentTimeMillis);
            userUnitRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserUnitRelation>) dao.batchSave(userUnitRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userUnitRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserUnitRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserUnitRelation userUnitRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userUnitRelation == null ? "null" : userUnitRelation.getId()));

        boolean result = false;

        if (userUnitRelation == null) {
            return true;
        }

        userUnitRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userUnitRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userUnitRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userUnitRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserUnitRelation> userUnitRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userUnitRelationList == null ? "null" : userUnitRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userUnitRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserUnitRelation userUnitRelation : userUnitRelationList) {
            userUnitRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userUnitRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userUnitRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userUnitRelationList.size());

        return result;
    }


    @Override
    public UserUnitRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserUnitRelation userUnitRelation = null;

        if (id == null) {
            return userUnitRelation;
        }

        try {
            userUnitRelation = (UserUnitRelation) dao.get(UserUnitRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userUnitRelation;
    }


    @Override
    public List<UserUnitRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserUnitRelation> userUnitRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserUnitRelation>();
        }

        try {
            userUnitRelation = (List<UserUnitRelation>) dao.getList(UserUnitRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userUnitRelation == null ? "null" : userUnitRelation.size()));

        return userUnitRelation;
    }

//	@Override
//	public List<Long> getUserUnitRelationIdByUserIdAndUnitId(Long userId, Long unitId) throws ServiceException, ServiceDaoException {
//		return null;
//	}


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserUnitRelationIdByUserIdAndUnitId(Long userId, Long unitId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by userId,unitId  : " + userId + " , " + unitId);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        try {


            idList = dao.getIdList("getUserUnitRelationIdByUserIdAndUnitId", new Object[]{userId, unitId}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by userId,unitId  : " + userId + " , " + unitId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : ");
        }
        return idList;


    }


    @Override
    public List<Long> getUserUnitRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserUnitRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserUnitRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserUnitRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserUnitRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

