package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class UserOrderServiceImpl extends BaseDaoServiceImpl implements UserOrderService {


    private static final Log log = LogFactory.getLog("order");

    @Autowired
    UserPaperRelationService userPaperRelationService;
    @Autowired
    PeriodService periodService;
    @Autowired
    UserService userService;
    @Autowired
    LocksService locksService;
    @Autowired
    LessonService lessonService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserRecommendService userRecommendService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    RecommendStatisticsService recommendStatisticsService;
    @Autowired
    OrderStatisticsService orderStatisticsService;

    @Override
    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userOrder);

        if (userOrder == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(currentTimeMillis);
        userOrder.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userOrder);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        List<UserOrder> resultList = null;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(currentTimeMillis);
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserOrder>) dao.batchSave(userOrderList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userOrder == null ? "null" : userOrder.getId()));

        boolean result = false;

        if (userOrder == null) {
            return true;
        }

        userOrder.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userOrder);
        } catch (DaoException e) {
            log.error(" update wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userOrder);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userOrderList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userOrderList.size());

        return result;
    }


    @Override
    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserOrder userOrder = null;

        if (id == null) {
            return userOrder;
        }

        try {
            userOrder = (UserOrder) dao.get(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userOrder;
    }


    @Override
    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserOrder> userOrder = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }

        try {
            userOrder = (List<UserOrder>) dao.getList(UserOrder.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userOrder == null ? "null" : userOrder.size()));

        return userOrder;
    }

    @Override
    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by order_id  : " + orderId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getIdByOrderId", new Object[]{orderId});
        } catch (DaoException e) {
            log.error(" get id wrong by orderId  : " + orderId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return getObjectById(id);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
        }
        List<Long> ids = null;

        // TODO 参数检查!

        try {

            ids = dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,buyType  : " + uid + " , " + buyType);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserOrderIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserOrderIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserOrderIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }


    //在发送课程资料的时候，将课程所有的课时（包括上下架）资料全部发送
    //已经下架的课时，可以发送资料
    @Override
    public void noticeBack(String indentCode, int respCode, int payManner, String os) throws ServiceException, ServiceDaoException {


    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }


    public void addOrderStatistics(Integer buyType, Integer payManner, BigDecimal price) throws ServiceException, ServiceDaoException {

        log.info(" add recommend statistics ");

        Long staticAt = MyTimeUtil.getTodayZeroTimeMillions();
        log.info(" today is = " + getDate(staticAt));

        Long sid = orderStatisticsService.getOrderStatisticsIdByStaticAt(staticAt);
        OrderStatistics orderStatistics = orderStatisticsService.getObjectById(sid);

        if (orderStatistics != null) {
            log.info(" add 1 ");
            orderStatistics.setOrderCount(orderStatistics.getOrderCount() + 1);
            orderStatistics.setTotalAmount(orderStatistics.getTotalAmount().add(price));
            switch (buyType) {
                case UserOrder.ORDER_LESSON: {
                    orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_PERIOD: {
                    orderStatistics.setLessonCount(orderStatistics.getLessonCount() + 1);
                    orderStatistics.setLessonAmount(orderStatistics.getLessonAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_LPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_PPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_BPAPER: {
                    orderStatistics.setPaperCount(orderStatistics.getPaperCount() + 1);
                    orderStatistics.setPaperAmount(orderStatistics.getPaperAmount().add(price));
                    break;
                }
                case UserOrder.ORDER_MEMBER: {
                    orderStatistics.setVipCount(orderStatistics.getVipCount() + 1);
                    orderStatistics.setVipAmount(orderStatistics.getVipAmount().add(price));
                    break;
                }
            }

            switch (payManner) {
                case UserOrder.PAYMANNER_3: {
                    orderStatistics.setAlipayAmount(orderStatistics.getAlipayAmount().add(price));
                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderStatistics.setWeixinAmount(orderStatistics.getWeixinAmount().add(price));
                    break;
                }
                case UserOrder.PAYMANNER_5: {
                    orderStatistics.setAppleAmount(orderStatistics.getAppleAmount().add(price));
                    break;
                }
            }

            orderStatisticsService.update(orderStatistics);
        } else {
            log.info(" new  recommendStatistics  ");
            orderStatistics = new OrderStatistics();
            orderStatistics.setStaticAt(staticAt);
            orderStatistics.setOrderCount(1);
            orderStatistics.setTotalAmount(price);
            switch (buyType) {
                case UserOrder.ORDER_LESSON: {
                    orderStatistics.setLessonCount(1);
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case UserOrder.ORDER_PERIOD: {
                    orderStatistics.setLessonCount(1);
                    orderStatistics.setLessonAmount(price);
                    break;
                }
                case UserOrder.ORDER_LPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_PPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_BPAPER: {
                    orderStatistics.setPaperCount(1);
                    orderStatistics.setPaperAmount(price);
                    break;
                }
                case UserOrder.ORDER_MEMBER: {
                    orderStatistics.setVipCount(1);
                    orderStatistics.setVipAmount(price);
                    break;
                }
            }

            switch (payManner) {
                case UserOrder.PAYMANNER_3: {
                    orderStatistics.setAlipayAmount(price);
                    break;
                }
                case UserOrder.PAYMANNER_4: {
                    orderStatistics.setWeixinAmount(price);
                    break;
                }
                case UserOrder.PAYMANNER_5: {
                    orderStatistics.setAppleAmount(price);
                    break;
                }
            }
            orderStatisticsService.insert(orderStatistics);
        }

    }
}

