package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.UserCourseShareRelation;
import com.ptteng.academy.course.service.UserCourseShareRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserCourseShareRelationServiceImpl extends BaseDaoServiceImpl implements UserCourseShareRelationService {

 

	private static final Log log = LogFactory.getLog(UserCourseShareRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserCourseShareRelation userCourseShareRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userCourseShareRelation);

		if (userCourseShareRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userCourseShareRelation.setCreateAt(currentTimeMillis);
		userCourseShareRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userCourseShareRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userCourseShareRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserCourseShareRelation> insertList(List<UserCourseShareRelation> userCourseShareRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userCourseShareRelationList == null ? "null" : userCourseShareRelationList.size()));
      
		List<UserCourseShareRelation> resultList = null;

		if (CollectionUtils.isEmpty(userCourseShareRelationList)) {
			return new ArrayList<UserCourseShareRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCourseShareRelation userCourseShareRelation : userCourseShareRelationList) {
			userCourseShareRelation.setCreateAt(currentTimeMillis);
			userCourseShareRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserCourseShareRelation>) dao.batchSave(userCourseShareRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userCourseShareRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserCourseShareRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserCourseShareRelation userCourseShareRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userCourseShareRelation == null ? "null" : userCourseShareRelation.getId()));

		boolean result = false;

		if (userCourseShareRelation == null) {
			return true;
		}

		userCourseShareRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userCourseShareRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userCourseShareRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userCourseShareRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserCourseShareRelation> userCourseShareRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userCourseShareRelationList == null ? "null" : userCourseShareRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userCourseShareRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserCourseShareRelation userCourseShareRelation : userCourseShareRelationList) {
			userCourseShareRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userCourseShareRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userCourseShareRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userCourseShareRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserCourseShareRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserCourseShareRelation userCourseShareRelation = null;

		if (id == null) {
			return userCourseShareRelation;
		}

		try {
			userCourseShareRelation = (UserCourseShareRelation) dao.get(UserCourseShareRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userCourseShareRelation;		
		}	
		  
    	   
		@Override
		public List<UserCourseShareRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserCourseShareRelation> userCourseShareRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserCourseShareRelation>();
		}

		try {
			userCourseShareRelation = (List<UserCourseShareRelation>) dao.getList(UserCourseShareRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userCourseShareRelation == null ? "null" : userCourseShareRelation.size()));
    
		return userCourseShareRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long getUserCourseShareRelationIdByUserIdAndTargetId(Long userId, Long targetId)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by userId,targetId  : " + userId+" , "+targetId );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserCourseShareRelationIdByUserIdAndTargetId", new Object[] {userId,targetId });
   } catch (DaoException e) {
			log.error(" get id wrong by userId,targetId  : " + userId+" , "+targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserCourseShareRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserCourseShareRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserCourseShareRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserCourseShareRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserCourseShareRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

