package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Progress;
import com.ptteng.academy.course.service.ProgressService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ProgressServiceImpl extends BaseDaoServiceImpl implements ProgressService {


    private static final Log log = LogFactory.getLog(ProgressServiceImpl.class);


    @Override
    public Long insert(Progress progress) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + progress);

        if (progress == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        progress.setCreateAt(currentTimeMillis);
        progress.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(progress);
        } catch (DaoException e) {
            log.error(" insert wrong : " + progress);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Progress> insertList(List<Progress> progressList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (progressList == null ? "null" : progressList.size()));

        List<Progress> resultList = null;

        if (CollectionUtils.isEmpty(progressList)) {
            return new ArrayList<Progress>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Progress progress : progressList) {
            progress.setCreateAt(currentTimeMillis);
            progress.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Progress>) dao.batchSave(progressList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + progressList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Progress.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Progress progress) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (progress == null ? "null" : progress.getId()));

        boolean result = false;

        if (progress == null) {
            return true;
        }

        progress.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(progress);
        } catch (DaoException e) {
            log.error(" update wrong : " + progress);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + progress);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Progress> progressList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (progressList == null ? "null" : progressList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(progressList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Progress progress : progressList) {
            progress.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(progressList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + progressList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + progressList.size());

        return result;
    }


    @Override
    public Progress getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Progress progress = null;

        if (id == null) {
            return progress;
        }

        try {
            progress = (Progress) dao.get(Progress.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return progress;
    }


    @Override
    public List<Progress> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Progress> progress = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Progress>();
        }

        try {
            progress = (List<Progress>) dao.getList(Progress.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (progress == null ? "null" : progress.size()));

        return progress;
    }

    @Override
    public List<Long> getBookProgressIdsByUserID(Long userID) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get book progress ids by user id : " + userID);
        }
        List<Long> ids = null;

        try {
            ids = dao.getIdList("getProgressIdsByUserIDAndType", new Object[]{userID}, 0, Integer.MAX_VALUE, false);


        } catch (DaoException e) {
            log.error(" get book progress ids wrong by user id : " + userID);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getProgressIdsByUserIDAndTypeOrderByCreateAt", new Object[]{userID, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getProgressIdsByUserIDAndTypeOrderByUpdateAt(Long userID, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by userID,type,start,limit  : " + userID + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getProgressIdsByUserIDAndTypeOrderByUpdateAt", new Object[]{userID, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by userID,type,start,limit)  : " + userID + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by userID,targetID,type,start,limit  : " + userID + " , " + targetID + " , " + type);
        }
        Long id = null;

        try {
            id = (Long) dao.getMapping("getProgressIdsByUserIDAndTargetIDAndType", new Object[]{userID, targetID, type});


        } catch (DaoException e) {
            log.error(" get ids  wrong by userID,targetID,type,start,limit)  : " + userID + " , " + targetID + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + id);
        }
        return id;

    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countProgressIdsByUserIDAndTypeOrderByCreateAt(Long userID, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by userID,type  : " + userID + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getProgressIdsByUserIDAndTypeOrderByCreateAt", new Object[]{userID, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by userID,type)  : " + userID + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countProgressIdsByUserIDAndTargetIDAndType(Long userID, Long targetID, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by userID,targetID,type  : " + userID + " , " + targetID + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getProgressIdsByUserIDAndTargetIDAndType", new Object[]{userID, targetID, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by userID,targetID,type)  : " + userID + " , " + targetID + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getProgressIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getProgressIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countProgressIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getProgressIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getProgressIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

