package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.Paper;
import com.ptteng.academy.course.service.PaperService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class PaperServiceImpl extends BaseDaoServiceImpl implements PaperService {


    private static final Log log = LogFactory.getLog(PaperServiceImpl.class);


    @Override
    public Long insert(Paper paper) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + paper);

        if (paper == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        paper.setCreateAt(currentTimeMillis);
        paper.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(paper);
        } catch (DaoException e) {
            log.error(" insert wrong : " + paper);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Paper> insertList(List<Paper> paperList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (paperList == null ? "null" : paperList.size()));

        List<Paper> resultList = null;

        if (CollectionUtils.isEmpty(paperList)) {
            return new ArrayList<Paper>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Paper paper : paperList) {
            paper.setCreateAt(currentTimeMillis);
            paper.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Paper>) dao.batchSave(paperList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + paperList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Paper.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Paper paper) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (paper == null ? "null" : paper.getId()));

        boolean result = false;

        if (paper == null) {
            return true;
        }

        paper.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(paper);
        } catch (DaoException e) {
            log.error(" update wrong : " + paper);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + paper);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Paper> paperList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (paperList == null ? "null" : paperList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(paperList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Paper paper : paperList) {
            paper.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(paperList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + paperList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + paperList.size());

        return result;
    }


    @Override
    public Paper getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Paper paper = null;

        if (id == null) {
            return paper;
        }

        try {
            paper = (Paper) dao.get(Paper.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return paper;
    }


    @Override
    public List<Paper> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Paper> paper = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Paper>();
        }

        try {
            paper = (List<Paper>) dao.getList(Paper.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (paper == null ? "null" : paper.size()));

        return paper;
    }


    @Override
    public List<Long> getPaperIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPaperIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getPaperIdByPeriodId(Long periodId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by period : " + periodId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getPaperIdByPeriodId", new Object[]{periodId});
        } catch (DaoException e) {
            log.error(" get id wrong by period : " + periodId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public String getPaperPriceByPeriodId(Long periodId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get price by period : " + periodId);
        }
        String price = "";

        // TODO 参数检查!

        try {

            price = (String) dao.getMapping("getPaperPriceByPeriodId", new Object[]{periodId});
        } catch (DaoException e) {
            log.error(" get price wrong by period : " + periodId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get price success : " + price);
        }
        return price;
    }


    @Override
    public Integer countPaperIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getPaperIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getPaperIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

