package com.ptteng.academy.course.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.course.model.GradeClassRelation;
import com.ptteng.academy.course.service.GradeClassRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class GradeClassRelationServiceImpl extends BaseDaoServiceImpl implements GradeClassRelationService {


    private static final Log log = LogFactory.getLog(GradeClassRelationServiceImpl.class);


    @Override
    public Long insert(GradeClassRelation gradeClassRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + gradeClassRelation);

        if (gradeClassRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        gradeClassRelation.setCreateAt(currentTimeMillis);
        gradeClassRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(gradeClassRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + gradeClassRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<GradeClassRelation> insertList(List<GradeClassRelation> gradeClassRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (gradeClassRelationList == null ? "null" : gradeClassRelationList.size()));

        List<GradeClassRelation> resultList = null;

        if (CollectionUtils.isEmpty(gradeClassRelationList)) {
            return new ArrayList<GradeClassRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (GradeClassRelation gradeClassRelation : gradeClassRelationList) {
            gradeClassRelation.setCreateAt(currentTimeMillis);
            gradeClassRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<GradeClassRelation>) dao.batchSave(gradeClassRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + gradeClassRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(GradeClassRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(GradeClassRelation gradeClassRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (gradeClassRelation == null ? "null" : gradeClassRelation.getId()));

        boolean result = false;

        if (gradeClassRelation == null) {
            return true;
        }

        gradeClassRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(gradeClassRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + gradeClassRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + gradeClassRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<GradeClassRelation> gradeClassRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (gradeClassRelationList == null ? "null" : gradeClassRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(gradeClassRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (GradeClassRelation gradeClassRelation : gradeClassRelationList) {
            gradeClassRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(gradeClassRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + gradeClassRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + gradeClassRelationList.size());

        return result;
    }


    @Override
    public GradeClassRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        GradeClassRelation gradeClassRelation = null;

        if (id == null) {
            return gradeClassRelation;
        }

        try {
            gradeClassRelation = (GradeClassRelation) dao.get(GradeClassRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return gradeClassRelation;
    }


    @Override
    public List<GradeClassRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<GradeClassRelation> gradeClassRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GradeClassRelation>();
        }

        try {
            gradeClassRelation = (List<GradeClassRelation>) dao.getList(GradeClassRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (gradeClassRelation == null ? "null" : gradeClassRelation.size()));

        return gradeClassRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getGradeClassRelationIdsByUidAndName(Long uid, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,name,start,limit  : " + uid + " , " + name + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getGradeClassRelationIdsByUidAndName", new Object[]{uid, name}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,name,start,limit)  : " + uid + " , " + name + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getGradeClassRelationIdsByLevel(Long subjectId, Integer level, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids by subjectid,level,start,limit  : " + subjectId + " , " + level + " , " + start + " , " + limit);

        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getGradeClassRelationIdsByLevel", new Object[]{subjectId, level}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,name,start,limit)  : " + subjectId + " , " + level + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public Long getGradeClassRelationIdsByGradeName(Long subjectId, Integer gradeName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,subjectId,gradeName : " + subjectId + " , " + gradeName);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getGradeClassRelationIdsByGradeName", new Object[]{subjectId, gradeName});
        } catch (DaoException e) {
            log.error(" get id wrong by subjectId,gradeName : " + subjectId + " , " + gradeName);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countGradeClassRelationIdsByUidAndName(Long uid, String name) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,name  : " + uid + " , " + name);
        }
        Integer count = null;


        try {

            count = dao.count("getGradeClassRelationIdsByUidAndName", new Object[]{uid, name});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,name)  : " + uid + " , " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }

    @Override
    public List<Long> getGradeClassRelationIdsBySubject(Long subjectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,name,start,limit  : " + subjectId + " , " + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getGradeClassRelationIdsBySubject", new Object[]{subjectId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,name,start,limit)  : " + subjectId + " , " + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;

    }

    @Override
    public List<Long> getGradeClassRelationIdsBySubjectOrderByGradeNameDesc(Long subjectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,name,start,limit  : " + subjectId + " , " + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getGradeClassRelationIdsBySubjectOrderByGradeNameDesc", new Object[]{subjectId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,name,start,limit)  : " + subjectId + " , " + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public List<Long> getGradeClassRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getGradeClassRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countGradeClassRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getGradeClassRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getGradeClassRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

